/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils.yaml;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.WeatherType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import me.sashie.skriptyaml.utils.yaml.SkriptClass;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

public class SkriptYamlRepresenter
extends Representer {
    private static List<String> representedClasses = new ArrayList<String>();

    public SkriptYamlRepresenter() {
        this.nullRepresenter = new Represent(){

            public Node representData(Object o) {
                return SkriptYamlRepresenter.this.representScalar(Tag.NULL, "");
            }
        };
        this.representers.put(SkriptClass.class, new RepresentSkriptClass());
        this.representers.put(ItemType.class, new RepresentSkriptItemType());
        this.representers.put(Slot.class, new RepresentSkriptSlot());
        this.representers.put(Date.class, new RepresentSkriptDate());
        this.representers.put(Time.class, new RepresentSkriptTime());
        this.representers.put(Timespan.class, new RepresentSkriptTimespan());
        this.representers.put(Color.class, new RepresentSkriptColor());
        this.representers.put(WeatherType.class, new RepresentSkriptWeather());
        this.representers.put(Vector.class, new RepresentVector());
        this.representers.put(Location.class, new RepresentLocation());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        for (Class c : this.representers.keySet()) {
            if (c == null) continue;
            representedClasses.add(c.getSimpleName());
        }
    }

    public static boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        return representedClasses.contains(object.getClass().getSimpleName());
    }

    private Node representConfigurationSerializable(Object data) {
        ConfigurationSerializable serializable = (ConfigurationSerializable)data;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
        values.putAll(serializable.serialize());
        return super.representData(values);
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super((SafeRepresenter)SkriptYamlRepresenter.this);
        }

        public Node representData(Object data) {
            return SkriptYamlRepresenter.this.representConfigurationSerializable(data);
        }
    }

    private class RepresentLocation
    implements Represent {
        private RepresentLocation() {
        }

        public Node representData(Object data) {
            LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
            Location loc = (Location)data;
            out.put("world", loc.getWorld().getName());
            out.put("x", loc.getX());
            out.put("y", loc.getY());
            out.put("z", loc.getZ());
            out.put("yaw", Double.valueOf(loc.getYaw()));
            out.put("pitch", Double.valueOf(loc.getPitch()));
            return SkriptYamlRepresenter.this.representMapping(new Tag("!location"), out, null);
        }
    }

    private class RepresentSkriptClass
    extends SafeRepresenter.RepresentMap {
        private RepresentSkriptClass() {
            super((SafeRepresenter)SkriptYamlRepresenter.this);
        }

        public Node representData(Object data) {
            LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
            SkriptClass skriptClass = (SkriptClass)data;
            out.put("type", skriptClass.getType());
            out.put("data", skriptClass.getData());
            return SkriptYamlRepresenter.this.representMapping(new Tag("!skriptclass"), out, null);
        }
    }

    private class RepresentSkriptColor
    implements Represent {
        private RepresentSkriptColor() {
        }

        public Node representData(Object data) {
            return SkriptYamlRepresenter.this.representScalar(new Tag("!skriptcolor"), ((Color)data).toString(), null);
        }
    }

    private class RepresentSkriptDate
    implements Represent {
        private RepresentSkriptDate() {
        }

        public Node representData(Object data) {
            int gmtOffset;
            Calendar calendar = Calendar.getInstance(SkriptYamlRepresenter.this.getTimeZone() == null ? TimeZone.getTimeZone("UTC") : SkriptYamlRepresenter.this.timeZone);
            calendar.setTime(new java.util.Date(((Date)data).getTimestamp()));
            int years = calendar.get(1);
            int months = calendar.get(2) + 1;
            int days = calendar.get(5);
            int hour24 = calendar.get(11);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            int millis = calendar.get(14);
            StringBuilder buffer = new StringBuilder(String.valueOf(years));
            while (buffer.length() < 4) {
                buffer.insert(0, "0");
            }
            buffer.append("-");
            if (months < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(months));
            buffer.append("-");
            if (days < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(days));
            buffer.append("T");
            if (hour24 < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(hour24));
            buffer.append(":");
            if (minutes < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(minutes));
            buffer.append(":");
            if (seconds < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(seconds));
            if (millis > 0) {
                if (millis < 10) {
                    buffer.append(".00");
                } else if (millis < 100) {
                    buffer.append(".0");
                } else {
                    buffer.append(".");
                }
                buffer.append(String.valueOf(millis));
            }
            if ((gmtOffset = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14))) == 0) {
                buffer.append('Z');
            } else {
                if (gmtOffset < 0) {
                    buffer.append('-');
                    gmtOffset *= -1;
                } else {
                    buffer.append('+');
                }
                int minutesOffset = gmtOffset / 60000;
                int hoursOffset = minutesOffset / 60;
                int partOfHour = minutesOffset % 60;
                if (hoursOffset < 10) {
                    buffer.append('0');
                }
                buffer.append(hoursOffset);
                buffer.append(':');
                if (partOfHour < 10) {
                    buffer.append('0');
                }
                buffer.append(partOfHour);
            }
            return SkriptYamlRepresenter.this.representScalar(new Tag("!skriptdate"), buffer.toString(), null);
        }
    }

    private class RepresentSkriptItemType
    extends SafeRepresenter.RepresentMap {
        private RepresentSkriptItemType() {
            super((SafeRepresenter)SkriptYamlRepresenter.this);
        }

        public Node representData(Object data) {
            ItemStack item = null;
            return SkriptYamlRepresenter.this.representConfigurationSerializable(((ItemType)data).addTo(item));
        }
    }

    private class RepresentSkriptSlot
    extends SafeRepresenter.RepresentMap {
        private RepresentSkriptSlot() {
            super((SafeRepresenter)SkriptYamlRepresenter.this);
        }

        public Node representData(Object data) {
            return SkriptYamlRepresenter.this.representConfigurationSerializable(((Slot)data).getItem());
        }
    }

    private class RepresentSkriptTime
    implements Represent {
        private RepresentSkriptTime() {
        }

        public Node representData(Object data) {
            return SkriptYamlRepresenter.this.representScalar(new Tag("!skripttime"), ((Time)data).toString(), null);
        }
    }

    private class RepresentSkriptTimespan
    implements Represent {
        private RepresentSkriptTimespan() {
        }

        public Node representData(Object data) {
            return SkriptYamlRepresenter.this.representScalar(new Tag("!skripttimespan"), ((Timespan)data).toString(), null);
        }
    }

    private class RepresentSkriptWeather
    implements Represent {
        private RepresentSkriptWeather() {
        }

        public Node representData(Object data) {
            return SkriptYamlRepresenter.this.representScalar(new Tag("!skriptweather"), ((WeatherType)data).toString().toLowerCase(), null);
        }
    }

    private class RepresentVector
    implements Represent {
        private RepresentVector() {
        }

        public Node representData(Object data) {
            LinkedHashMap<String, Double> out = new LinkedHashMap<String, Double>();
            Vector vec = (Vector)data;
            out.put("x", vec.getX());
            out.put("y", vec.getY());
            out.put("z", vec.getZ());
            return SkriptYamlRepresenter.this.representMapping(new Tag("!vector"), out, null);
        }
    }
}

