/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="Save YAML")
@Description(value={"Saves the current cached YAML elements to file.\n\t - Option to remove extra lines between nodes"})
@Examples(value={"save yaml \"config\""})
@Since(value="1.0.0")
public class EffSaveYaml
extends Effect {
    private Expression<String> file;
    private int mark;

    static {
        Skript.registerEffect(EffSaveYaml.class, (String[])new String[]{"save [y[a]ml] %string% [(1\u00a6without extra lines between nodes)]"});
    }

    protected void execute(@Nullable Event event) {
        String name = (String)this.file.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            return;
        }
        YAMLProcessor yaml = SkriptYaml.YAML_STORE.get(name);
        yaml.save(this.mark != 1);
    }

    public String toString(@Nullable Event event, boolean b) {
        return "save yaml " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.mark = parse.mark;
        return true;
    }
}

