/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.AsyncEffectOld;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import org.bukkit.event.Event;

@Name(value="Delete all loaded YAML from directory")
@Description(value={"Only deletes a directory of loaded YAML files and removes them from memory.\n  - The input is a directory (ie. \"plugins/MyAwesomePlugin/\").\n  - If for example a file in that directory is named test.yml then the output ID would be 'plugins/MyAwesomePlugin/test.yml'\n  - Using the optional filename ID would output `test.yml`"})
@Examples(value={"delete all yaml from directory \"/plugins/skript-yaml/test\""})
@Since(value="1.2.1")
public class EffDeleteLoadedYamlFromDirectory
extends AsyncEffectOld {
    private Expression<String> file;
    private int mark;
    private int matchedPattern;

    static {
        Skript.registerEffect(EffDeleteLoadedYamlFromDirectory.class, (String[])new String[]{"delete (all|any) loaded [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%", "delete (all|any) loaded [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }

    public File[] filter(String name) {
        File dir = null;
        if (this.mark == 1) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            SkriptYaml.warn("[Delete Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    protected void execute(@Nullable Event event) {
        String[] stringArray = (String[])this.file.getAll(event);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File[] fileArray = this.filter(StringUtil.checkSeparator(name));
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File yamlFile = fileArray[n4];
                String n5 = this.matchedPattern == 1 ? yamlFile.getName() : String.valueOf(StringUtil.checkLastSeparator(name)) + yamlFile.getName();
                if (SkriptYaml.YAML_STORE.containsKey(n5)) {
                    SkriptYaml.YAML_STORE.get(n5).getFile().delete();
                    SkriptYaml.YAML_STORE.remove(n5);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "delete all yaml from director(y|ies) " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        return true;
    }
}

