/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils.yaml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import me.sashie.skriptyaml.utils.yaml.SkriptClass;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.util.Vector;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

public class SkriptYamlRepresenter
extends Representer {
    private static List<String> representedClasses = new ArrayList<String>();

    public SkriptYamlRepresenter() {
        this.nullRepresenter = new Represent(){

            public Node representData(Object o) {
                return SkriptYamlRepresenter.this.representScalar(Tag.NULL, "");
            }
        };
        this.representers.put(SkriptClass.class, new RepresentSkriptClass());
        this.representers.put(Vector.class, new RepresentVector());
        this.representers.put(Location.class, new RepresentLocation());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        for (Class c : this.representers.keySet()) {
            if (c == null) continue;
            representedClasses.add(c.getSimpleName());
        }
    }

    public static boolean contains(Object object) {
        return representedClasses.contains(object.getClass().getSimpleName());
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super((SafeRepresenter)SkriptYamlRepresenter.this);
        }

        public Node representData(Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }

    private class RepresentLocation
    implements Represent {
        private RepresentLocation() {
        }

        public Node representData(Object o) {
            LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
            Location loc = (Location)o;
            out.put("world", loc.getWorld().getName());
            out.put("x", loc.getX());
            out.put("y", loc.getY());
            out.put("z", loc.getZ());
            out.put("yaw", Double.valueOf(loc.getYaw()));
            out.put("pitch", Double.valueOf(loc.getPitch()));
            return SkriptYamlRepresenter.this.representMapping(new Tag("!location"), out, null);
        }
    }

    private class RepresentSkriptClass
    extends SafeRepresenter.RepresentMap {
        private RepresentSkriptClass() {
            super((SafeRepresenter)SkriptYamlRepresenter.this);
        }

        public Node representData(Object data) {
            LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
            SkriptClass skriptClass = (SkriptClass)data;
            out.put("type", skriptClass.getType());
            out.put("data", skriptClass.getData());
            return SkriptYamlRepresenter.this.representMapping(new Tag("!skriptclass"), out, null);
        }
    }

    private class RepresentVector
    implements Represent {
        private RepresentVector() {
        }

        public Node representData(Object o) {
            LinkedHashMap<String, Double> out = new LinkedHashMap<String, Double>();
            Vector vec = (Vector)o;
            out.put("x", vec.getX());
            out.put("y", vec.getY());
            out.put("z", vec.getZ());
            return SkriptYamlRepresenter.this.representMapping(new Tag("!vector"), out, null);
        }
    }
}

