/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;

public final class StringUtil {
    private StringUtil() {
    }

    public static String replaceTabs(String text) {
        if (text.contains("\t")) {
            return text.replaceAll("\t", "    ");
        }
        return text;
    }

    public static String checkSeparator(String check) {
        if (check.contains("/")) {
            return check.replaceAll("/", Matcher.quoteReplacement(File.separator));
        }
        return check;
    }

    public static String checkLastSeparator(String check) {
        if (check.contains("/")) {
            if (!check.endsWith("/")) {
                return String.valueOf(check) + "/";
            }
        } else if (check.contains("\\")) {
            if (!check.endsWith("\\")) {
                return String.valueOf(check) + "\\";
            }
        } else if (!check.contains("/") || !check.contains("\\")) {
            return String.valueOf(check) + Matcher.quoteReplacement(File.separator);
        }
        return check;
    }

    public static String checkRoot(String check) {
        Path root = Paths.get("", new String[0]).normalize().toAbsolutePath().getRoot();
        if (root != null) {
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File r = fileArray[n2];
                if (check.toLowerCase().startsWith(r.getPath().toLowerCase())) {
                    return check;
                }
                ++n2;
            }
            return root + check;
        }
        return String.valueOf(File.separator) + check;
    }

    public static String stripExtention(String strip) {
        int pos = strip.lastIndexOf(".");
        if (pos > 0) {
            return strip.substring(0, pos);
        }
        return strip;
    }

    public static String trimLength(String str, int len) {
        if (str.length() > len) {
            return str.substring(0, len);
        }
        return str;
    }

    public static String joinString(String[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(str[initialIndex]);
        int i = initialIndex + 1;
        while (i < str.length) {
            buffer.append(delimiter).append(str[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String joinQuotedString(String[] str, String delimiter, int initialIndex, String quote) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        buffer.append(str[initialIndex]);
        buffer.append(quote);
        int i = initialIndex + 1;
        while (i < str.length) {
            buffer.append(delimiter).append(quote).append(str[i]).append(quote);
            ++i;
        }
        return buffer.toString();
    }

    public static String joinString(String[] str, String delimiter) {
        return StringUtil.joinString(str, delimiter, 0);
    }

    public static String joinString(Object[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(str[initialIndex].toString());
        int i = initialIndex + 1;
        while (i < str.length) {
            buffer.append(delimiter).append(str[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String joinString(int[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(Integer.toString(str[initialIndex]));
        int i = initialIndex + 1;
        while (i < str.length) {
            buffer.append(delimiter).append(Integer.toString(str[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static String joinString(Collection<?> str, String delimiter, int initialIndex) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        for (Object o : str) {
            if (i >= initialIndex) {
                if (i > 0) {
                    buffer.append(delimiter);
                }
                buffer.append(o);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int getLevenshteinDistance(String s, String t) {
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int i = 0;
        while (i <= n) {
            p[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= m) {
            char tj = t.charAt(j - 1);
            d[0] = j;
            i = 1;
            while (i <= n) {
                int cost = s.charAt(i - 1) == tj ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
                ++i;
            }
            int[] _d = p;
            p = d;
            d = _d;
            ++j;
        }
        return p[n];
    }

    public static <T extends Enum<?>> T lookup(Map<String, T> lookup, String name, boolean fuzzy) {
        String testName = name.replaceAll("[ _]", "").toLowerCase();
        Enum type = (Enum)lookup.get(testName);
        if (type != null) {
            return (T)type;
        }
        if (!fuzzy) {
            return null;
        }
        int minDist = -1;
        for (Map.Entry<String, T> entry : lookup.entrySet()) {
            int dist;
            String key = entry.getKey();
            if (key.charAt(0) != testName.charAt(0) || (dist = StringUtil.getLevenshteinDistance(key, testName)) >= minDist && minDist != -1 || dist >= 2) continue;
            minDist = dist;
            type = (Enum)entry.getValue();
        }
        return (T)type;
    }
}

