/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils.yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLNode;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessorException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class YAMLProcessor
extends YAMLNode {
    public static final String LINE_BREAK = DumperOptions.LineBreak.getPlatformLineBreak().getString();
    public static final char COMMENT_CHAR = '#';
    protected final Yaml yaml;
    protected final File file;
    protected String header = null;
    protected YAMLFormat format;
    private final Map<String, String> comments = new HashMap<String, String>();

    public YAMLProcessor(File file, boolean writeDefaults, YAMLFormat format) {
        super(new LinkedHashMap<String, Object>(), writeDefaults);
        this.format = format;
        FancyDumperOptions options = new FancyDumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(format.getStyle());
        FancyRepresenter representer = new FancyRepresenter();
        representer.setDefaultFlowStyle(format.getStyle());
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), (Representer)representer, (DumperOptions)options);
        this.file = file;
    }

    public YAMLProcessor(File file, boolean writeDefaults) {
        this(file, writeDefaults, YAMLFormat.COMPACT);
    }

    public void load() throws IOException {
        InputStream stream = null;
        try {
            try {
                stream = this.getInputStream();
                if (stream == null) {
                    throw new IOException("Stream is null!");
                }
                this.read(this.yaml.load((Reader)new UnicodeReader(stream)));
            }
            catch (YAMLProcessorException e) {
                this.root = new LinkedHashMap();
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setHeader(String ... headerLines) {
        StringBuilder header = new StringBuilder();
        String[] stringArray = headerLines;
        int n = headerLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (header.length() > 0) {
                header.append(LINE_BREAK);
            }
            if (line.startsWith("#")) {
                header.append("#");
            } else {
                header.append("## ");
            }
            header.append(StringUtil.replaceTabs(line));
            ++n2;
        }
        this.setHeader(header.toString());
    }

    public void setHeader(String header) {
        this.header = StringUtil.replaceTabs(header);
    }

    public String getHeader() {
        return this.header;
    }

    public boolean save() {
        block22: {
            block21: {
                OutputStream stream = null;
                File parent = this.file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                try {
                    stream = this.getOutputStream();
                    if (stream == null) {
                        return false;
                    }
                    OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                    if (this.header != null) {
                        writer.append(this.header);
                        writer.append(LINE_BREAK);
                    }
                    if (this.comments.isEmpty() || this.format != YAMLFormat.EXTENDED) {
                        this.yaml.dump((Object)this.root, (Writer)writer);
                        break block21;
                    }
                    for (Map.Entry entry : this.root.entrySet()) {
                        String comment = this.comments.get(entry.getKey());
                        if (comment != null) {
                            writer.append(LINE_BREAK);
                            writer.append(comment);
                            writer.append(LINE_BREAK);
                        }
                        this.yaml.dump(Collections.singletonMap((String)entry.getKey(), entry.getValue()), (Writer)writer);
                    }
                }
                catch (IOException iOException) {
                    break block22;
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }
        return false;
    }

    private void recursiveKeySearch(String path, Object o) {
        for (Map.Entry entry : ((Map)o).entrySet()) {
            this.allKeys.add(String.valueOf(path) + "." + (String)entry.getKey());
            if (!(entry.getValue() instanceof Map)) continue;
            this.recursiveKeySearch(String.valueOf(path) + "." + (String)entry.getKey(), entry.getValue());
        }
    }

    private void read(Object input) throws YAMLProcessorException {
        try {
            if (input == null) {
                this.root = new LinkedHashMap();
            } else {
                this.root = new LinkedHashMap((Map)input);
                for (String path : this.root.keySet()) {
                    Object o = this.getProperty(path);
                    if (o == null) continue;
                    if (o instanceof Map) {
                        this.recursiveKeySearch(path, o);
                        continue;
                    }
                    this.allKeys.add(path);
                }
            }
        }
        catch (ClassCastException e) {
            throw new YAMLProcessorException("Root document must be a key-value structure");
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public String getComment(String key) {
        return this.comments.get(key);
    }

    public void setComment(String key, String comment) {
        if (comment != null) {
            this.setComment(key, comment.split("\\r?\\n"));
        } else {
            this.comments.remove(key);
        }
    }

    public void setComment(String key, String ... comment) {
        if (comment != null && comment.length > 0) {
            int i = 0;
            while (i < comment.length) {
                if (!comment[i].matches("^# ?")) {
                    comment[i] = "# " + comment[i];
                }
                ++i;
            }
            String s = StringUtil.joinString(comment, LINE_BREAK);
            this.comments.put(key, StringUtil.replaceTabs(s));
        } else {
            this.comments.remove(key);
        }
    }

    public Map<String, String> getComments() {
        return Collections.unmodifiableMap(this.comments);
    }

    public void setComments(Map<String, String> comments) {
        this.comments.clear();
        if (comments != null) {
            this.comments.putAll(comments);
        }
    }

    public static YAMLNode getEmptyNode(boolean writeDefaults) {
        return new YAMLNode(new LinkedHashMap<String, Object>(), writeDefaults);
    }

    private class FancyDumperOptions
    extends DumperOptions {
        private FancyDumperOptions() {
        }

        public void setDefaultScalarStyle(DumperOptions.ScalarStyle defaultStyle) {
            super.setDefaultScalarStyle(DumperOptions.ScalarStyle.LITERAL);
        }
    }

    private static class FancyRepresenter
    extends Representer {
        private FancyRepresenter() {
            this.nullRepresenter = new Represent(){

                public Node representData(Object o) {
                    return this.representScalar(Tag.NULL, "");
                }
            };
        }
    }
}

