/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.AsyncEffect;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="Load YAML")
@Description(value={"Loads a YAML file into memory.\n  - The first input is the YAML file path (ie. \"plugins/MyAwesomePlugin/config.yml\").\n  - The second input allows you to choose your own ID for this file.\n  - If the second input isn't used then the files name minus the extention is used as the ID for example `config.yml` becomes `config`."})
@Examples(value={"#Both examples produce the same id for use in other effects/expressions", "load yaml \"plugins/MyAwesomePlugin/config.yml\"", "load yaml \"plugins/MyAwesomePlugin/config.yml\" as \"config\"", " ", "#to get similar function as the other addons you would do this sort of thing with the id...", "\tload yaml \"plugins/MyAwesomePlugin/config.yml\" as \"plugins/MyAwesomePlugin/config.yml\"", "\tset yaml value \"version\" from \"plugins/MyAwesomePlugin/config.yml\" to 1.0", "\tbroadcast \"%yaml value \"\"version\"\" from \"\"plugins/MyAwesomePlugin/config.yml\"\"%\""})
@Since(value="1.0.0")
public class EffLoadYaml
extends AsyncEffect {
    private Expression<String> file;
    private Expression<String> id;
    private int mark = 0;

    static {
        Skript.registerEffect(EffLoadYaml.class, (String[])new String[]{"[re]load [(1\u00a6non[(-| )]relative)] [y[a]ml] %string% [as %-string%]"});
    }

    private String checkSeparator(String check) {
        if (check.contains("/")) {
            return check.replaceAll("/", Matcher.quoteReplacement(File.separator));
        }
        return check;
    }

    private String checkRoot(String check) {
        Path root = Paths.get("", new String[0]).normalize().toAbsolutePath().getRoot();
        if (root != null) {
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File r = fileArray[n2];
                if (check.toLowerCase().startsWith(r.getPath().toLowerCase())) {
                    return check;
                }
                ++n2;
            }
            return root + check;
        }
        return String.valueOf(File.separator) + check;
    }

    protected void execute(@Nullable Event event) {
        block17: {
            String name = this.checkSeparator((String)this.file.getSingle(event));
            File yamlFile = null;
            if (this.mark == 1) {
                yamlFile = new File(this.checkRoot(name));
            } else {
                Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
                yamlFile = new File(server + File.separator + name);
            }
            if (!yamlFile.exists()) {
                try {
                    if (!yamlFile.exists()) {
                        String filePath = yamlFile.getPath();
                        int index = filePath.lastIndexOf(File.separator);
                        File folder = new File(filePath.substring(0, index));
                        if (index >= 0 && !folder.exists()) {
                            folder.mkdirs();
                        }
                        yamlFile.createNewFile();
                    }
                }
                catch (IOException error) {
                    SkriptYaml.error("[Load Yaml] " + error.getMessage() + " (" + name + ")");
                    return;
                }
            }
            YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
            try {
                try {
                    yaml.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.id != null) {
                        SkriptYaml.YAML_STORE.put((String)this.id.getSingle(event), yaml);
                        break block17;
                    }
                    String n = yamlFile.getName();
                    int pos = n.lastIndexOf(".");
                    if (pos > 0) {
                        n = n.substring(0, pos);
                    }
                    SkriptYaml.YAML_STORE.put(n, yaml);
                }
            }
            finally {
                if (this.id != null) {
                    SkriptYaml.YAML_STORE.put((String)this.id.getSingle(event), yaml);
                } else {
                    String n = yamlFile.getName();
                    int pos = n.lastIndexOf(".");
                    if (pos > 0) {
                        n = n.substring(0, pos);
                    }
                    SkriptYaml.YAML_STORE.put(n, yaml);
                }
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load yaml " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.file = exprs[0];
        this.id = exprs[1];
        if (parser.mark == 1) {
            this.mark = 1;
        }
        return true;
    }
}

