/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="YAML")
@Description(value={"Gets, sets, removes values/nodes etc.. of a cached yaml file\n  - Requires the id used/created from the load effect\n  - This expression does not save to file\n  - Lists accept list variables for input\n  - Using 'without string checks' optional is a tiny bit faster but doesn't check/convert strings for numbers or booleans"})
@Examples(value={"set yaml value \"test1.test2\" from \"config\" to \"test3\"", "set yaml list \"list.name\" from \"config\" to {_list::*}", " ", "set {_test} to yaml value \"test1.test2\" from \"config\"", "broadcast \"%{_test}%\""})
@Since(value="1.0.0")
public class ExprYaml
extends SimpleExpression<Object> {
    private int matchedPattern;
    private Expression<String> node;
    private Expression<String> file;
    private States state;

    static {
        Skript.registerExpression(ExprYaml.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[[skript-]y[a]ml] (1\u00a6value|2\u00a6(node|path)[s]|3\u00a6(node|path)[s with] keys|4\u00a6list) %string% (of|in|from) %string%", "[[skript-]y[a]ml] (1\u00a6value|2\u00a6(node|path)[s]|3\u00a6(node|path)[s with] keys|4\u00a6list) %string% (of|in|from) %string% without string checks"});
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return this.state == States.VALUE;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "yaml " + this.state.toString().toLowerCase() + " " + this.node.toString(event, b) + " from " + this.file.toString(event, b) + (this.matchedPattern == 0 ? "" : " without string checks");
    }

    @Nullable
    protected Object[] get(Event event) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.node.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return null;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        if (this.state == States.VALUE) {
            Object o = config.getProperty(path);
            if (o != null) {
                return CollectionUtils.array((Object[])new Object[]{o});
            }
            return null;
        }
        if (this.state == States.NODES) {
            List<String> nodes = config.getAllKeys();
            if (nodes == null) {
                return null;
            }
            return nodes.toArray(new String[nodes.size()]);
        }
        if (this.state == States.NODES_KEYS) {
            List<String> nodesKeys = config.getKeys(path);
            if (nodesKeys == null) {
                return null;
            }
            return nodesKeys.toArray(new String[nodesKeys.size()]);
        }
        if (this.state == States.LIST) {
            List<Object> items = config.getList(path);
            if (items == null) {
                return null;
            }
            return items.toArray();
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.node.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            config.removeProperty(path);
            return;
        }
        if (this.state == States.VALUE) {
            if (mode == Changer.ChangeMode.SET) {
                config.setProperty(path, this.parseString(delta[0]));
            }
        } else if (this.state == States.NODES_KEYS) {
            if (mode == Changer.ChangeMode.ADD) {
                config.addNode(path);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                config.setProperty(String.valueOf(path) + "." + (delta[0] == null ? "" : delta[0]), null);
            }
        } else if (this.state == States.LIST) {
            ArrayList objects = (ArrayList)config.getList(path);
            if (mode == Changer.ChangeMode.ADD) {
                if (objects == null) {
                    config.setProperty(path, this.arrayToList(new ArrayList<Object>(), delta));
                } else {
                    this.arrayToList(objects, delta);
                }
            } else if (mode == Changer.ChangeMode.REMOVE) {
                Object[] objectArray = delta;
                int n = delta.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    objects.remove(this.parseString(o));
                    ++n2;
                }
            } else if (mode == Changer.ChangeMode.SET) {
                if (objects == null) {
                    config.setProperty(path, this.arrayToList(new ArrayList<Object>(), delta));
                } else {
                    objects.clear();
                    this.arrayToList(objects, delta);
                }
            }
        }
    }

    private ArrayList<Object> arrayToList(ArrayList<Object> list, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            list.add(this.parseString(o));
            ++n2;
        }
        return list;
    }

    private Object parseString(Object delta) {
        if (this.matchedPattern == 0 && String.class.isAssignableFrom(delta.getClass())) {
            String s = (String)delta;
            if (s.matches("true|false|yes|no|on|off")) {
                return s.matches("true|yes|on");
            }
            if (s.matches("(-)?\\d+")) {
                return Long.parseLong(s);
            }
            if (s.matches("(-)?\\d+(\\.\\d+)")) {
                return Double.parseDouble(s);
            }
            return s;
        }
        return delta;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        if (this.state == States.VALUE) {
            if (mode == Changer.ChangeMode.SET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
            }
        } else if (this.state == States.LIST && (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (parse.mark == 1) {
            this.state = States.VALUE;
        } else if (parse.mark == 2) {
            this.state = States.NODES;
        } else if (parse.mark == 3) {
            this.state = States.NODES_KEYS;
        } else if (parse.mark == 4) {
            this.state = States.LIST;
        }
        this.node = e[0];
        this.file = e[1];
        this.matchedPattern = matchedPattern;
        return true;
    }

    private static enum States {
        VALUE,
        NODES,
        NODES_KEYS,
        LIST;

    }
}

