/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;

public class ExprYaml
extends SimpleExpression<Object> {
    private int matchedPattern;
    private Expression<String> node;
    private Expression<String> file;
    private States state;

    static {
        Skript.registerExpression(ExprYaml.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[[skript-]y[a]ml] (1\u00a6value|2\u00a6(node|path)[s]|3\u00a6(node|path)[s with] keys|4\u00a6list) %string% (of|in|from) %string%", "[[skript-]y[a]ml] (1\u00a6value|2\u00a6(node|path)[s]|3\u00a6(node|path)[s with] keys|4\u00a6list) %string% (of|in|from) %string% without string checks"});
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return this.state == States.VALUE;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "yaml " + this.state.toString().toLowerCase() + " " + this.node.toString(event, b) + " from " + this.file.toString(event, b) + (this.matchedPattern == 0 ? "" : " without string checks");
    }

    @Nullable
    protected Object[] get(Event event) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.node.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml file by the name '" + name + "' has been loaded");
            return null;
        }
        YamlConfiguration config = SkriptYaml.YAML_STORE.get((Object)name).file;
        if (!config.contains(path)) {
            return null;
        }
        if (this.state == States.VALUE) {
            return CollectionUtils.array((Object[])new Object[]{config.get(path)});
        }
        if (this.state == States.NODES) {
            Set nodes = config.getConfigurationSection(path).getKeys(false);
            return nodes.toArray(new String[nodes.size()]);
        }
        if (this.state == States.NODES_KEYS) {
            Set nodesKeys = config.getConfigurationSection(path).getKeys(true);
            return nodesKeys.toArray(new String[nodesKeys.size()]);
        }
        if (this.state == States.LIST) {
            List items = config.getList(path);
            return items.toArray();
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.node.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return;
        }
        YamlConfiguration config = SkriptYaml.YAML_STORE.get((Object)name).file;
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            config.set(path, null);
            return;
        }
        if (this.state == States.VALUE) {
            if (mode == Changer.ChangeMode.SET) {
                config.set(path, this.parseString(delta[0]));
            }
        } else if (this.state == States.NODES_KEYS) {
            if (mode == Changer.ChangeMode.ADD) {
                config.createSection(path);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                config.set(String.valueOf(path) + "." + (delta[0] == null ? "" : delta[0]), null);
            }
        } else if (this.state == States.LIST) {
            ArrayList objects = (ArrayList)config.getList(path);
            if (mode == Changer.ChangeMode.ADD) {
                if (objects == null) {
                    config.set(path, this.arrayToList(new ArrayList<Object>(), delta));
                } else {
                    this.arrayToList(objects, delta);
                }
            } else if (mode == Changer.ChangeMode.REMOVE) {
                Object[] objectArray = delta;
                int n = delta.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    objects.remove(this.parseString(o));
                    ++n2;
                }
            } else if (mode == Changer.ChangeMode.SET) {
                if (objects == null) {
                    config.set(path, this.arrayToList(new ArrayList<Object>(), delta));
                } else {
                    objects.clear();
                    this.arrayToList(objects, delta);
                }
            }
        }
    }

    private ArrayList<Object> arrayToList(ArrayList<Object> list, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            list.add(this.parseString(o));
            ++n2;
        }
        return list;
    }

    private Object parseString(Object delta) {
        if (this.matchedPattern == 0 && String.class.isAssignableFrom(delta.getClass())) {
            String s = (String)delta;
            if (s.matches("true|false|yes|no|on|off")) {
                return s.matches("true|yes|on");
            }
            if (s.matches("(-)?\\d+")) {
                return Long.parseLong(s);
            }
            if (s.matches("(-)?\\d+(\\.\\d+)")) {
                return Double.parseDouble(s);
            }
            return s;
        }
        return delta;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        if (this.state == States.VALUE) {
            if (mode == Changer.ChangeMode.SET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
            }
        } else if (this.state == States.LIST && (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (parse.mark == 1) {
            this.state = States.VALUE;
        } else if (parse.mark == 2) {
            this.state = States.NODES;
        } else if (parse.mark == 3) {
            this.state = States.NODES_KEYS;
        } else if (parse.mark == 4) {
            this.state = States.LIST;
        }
        this.node = e[0];
        this.file = e[1];
        this.matchedPattern = matchedPattern;
        return true;
    }

    private static enum States {
        VALUE,
        NODES,
        NODES_KEYS,
        LIST;

    }
}

