/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.Option;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.variables.Variables;
import com.btk5h.skriptmirror.skript.custom.event.ExprReplacedEventValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.event.Event;

public class SkriptReflection {
    private static Field PATTERNS;
    private static Field PARAMETERS;
    private static Field HANDLERS;
    private static Field CURRENT_OPTIONS;
    private static Field LOCAL_VARIABLES;
    private static Field NODES;
    private static Field VARIABLES_MAP_HASHMAP;
    private static Field VARIABLES_MAP_TREEMAP;
    private static Constructor VARIABLES_MAP;
    private static Field DEFAULT_EXPRESSION;
    private static Field PARSED_VALUE;

    public static void setPatterns(SyntaxElementInfo<?> info, String[] patterns) {
        try {
            PATTERNS.set(info, patterns);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Parameter<?>[] getParameters(Function<?> function) {
        if (PARAMETERS == null) {
            return function.getParameters();
        }
        try {
            return (Parameter[])PARAMETERS.get(function);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static void printLog(RetainingLogHandler logger) {
        LogHandler nextHandler;
        HandlerList handler;
        logger.stop();
        try {
            handler = (HandlerList)HANDLERS.get(logger);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        Iterator handlers = handler.iterator();
        ArrayList<LogHandler> parseLogs = new ArrayList<LogHandler>();
        while (handlers.hasNext() && (nextHandler = (LogHandler)handlers.next()) instanceof ParseLogHandler) {
            parseLogs.add(nextHandler);
        }
        parseLogs.forEach(LogHandler::stop);
        SkriptLogger.logAll((Collection)logger.getLog());
    }

    public static Map<String, String> getCurrentOptions() {
        try {
            return (Map)CURRENT_OPTIONS.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static void putLocals(Object originalVariablesMap, Event to) {
        if (originalVariablesMap == null) {
            SkriptReflection.removeLocals(to);
        }
        try {
            Map localVariables = (Map)LOCAL_VARIABLES.get(null);
            localVariables.put(to, originalVariablesMap);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object removeLocals(Event event) {
        try {
            Map localVariables = (Map)LOCAL_VARIABLES.get(null);
            return localVariables.remove(event);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getLocals(Event event) {
        try {
            Map localVariables = (Map)LOCAL_VARIABLES.get(null);
            return localVariables.get(event);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object copyLocals(Object locals) {
        if (locals == null) {
            return null;
        }
        try {
            Object copiedLocals = VARIABLES_MAP.newInstance(new Object[0]);
            ((Map)VARIABLES_MAP_HASHMAP.get(copiedLocals)).putAll((Map)VARIABLES_MAP_HASHMAP.get(locals));
            ((Map)VARIABLES_MAP_TREEMAP.get(copiedLocals)).putAll((Map)VARIABLES_MAP_TREEMAP.get(locals));
            return copiedLocals;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<Node> getNodes(SectionNode sectionNode) {
        try {
            return (ArrayList)NODES.get(sectionNode);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new ArrayList<Node>();
        }
    }

    public static void replaceEventValues(List<ClassInfo<?>> classInfoList) {
        if (DEFAULT_EXPRESSION == null) {
            return;
        }
        try {
            ArrayList replaceExtraList = new ArrayList();
            for (ClassInfo<?> classInfo : classInfoList) {
                DefaultExpression defaultExpression = classInfo.getDefaultExpression();
                if (!(defaultExpression instanceof EventValueExpression) || defaultExpression instanceof ExprReplacedEventValue) continue;
                DEFAULT_EXPRESSION.set(classInfo, (Object)new ExprReplacedEventValue((EventValueExpression)defaultExpression));
                replaceExtraList.add(classInfo);
            }
            replaceExtraList.forEach(SkriptReflection::replaceExtra);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void replaceExtra(ClassInfo<?> classInfo) {
        List<ClassInfo<?>> classInfoList = Classes.getClassInfos().stream().filter(loopedClassInfo -> !(loopedClassInfo.getDefaultExpression() instanceof ExprReplacedEventValue)).filter(loopedClassInfo -> classInfo.getC().isAssignableFrom(loopedClassInfo.getC()) || loopedClassInfo.getC().isAssignableFrom(classInfo.getC())).collect(Collectors.toList());
        SkriptReflection.replaceEventValues(classInfoList);
    }

    public static void disableAndOrWarnings() {
        Option option = SkriptConfig.disableMissingAndOrWarnings;
        if (!((Boolean)option.value()).booleanValue()) {
            try {
                PARSED_VALUE.set(option, true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Field _FIELD;
        try {
            _FIELD = SyntaxElementInfo.class.getDeclaredField("patterns");
            _FIELD.setAccessible(true);
            PATTERNS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's pattern info field could not be resolved. Custom syntax will not work.");
        }
        try {
            _FIELD = Function.class.getDeclaredField("parameters");
            _FIELD.setAccessible(true);
            PARAMETERS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        try {
            _FIELD = SkriptLogger.class.getDeclaredField("handlers");
            _FIELD.setAccessible(true);
            HANDLERS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's handlers field could not be resolved. Some Skript warnings may not be available.");
        }
        try {
            _FIELD = ScriptLoader.class.getDeclaredField("currentOptions");
            _FIELD.setAccessible(true);
            CURRENT_OPTIONS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's options field could not be resolved.");
        }
        try {
            _FIELD = Variables.class.getDeclaredField("localVariables");
            _FIELD.setAccessible(true);
            LOCAL_VARIABLES = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's local variables field could not be resolved.");
        }
        try {
            _FIELD = SectionNode.class.getDeclaredField("nodes");
            _FIELD.setAccessible(true);
            NODES = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's nodes field could not be resolved, therefore sections won't work.");
        }
        try {
            Class<?> variablesMap = Class.forName("ch.njol.skript.variables.VariablesMap");
            try {
                _FIELD = variablesMap.getDeclaredField("hashMap");
                _FIELD.setAccessible(true);
                VARIABLES_MAP_HASHMAP = _FIELD;
            }
            catch (NoSuchFieldException e) {
                Skript.warning((String)"Skript's hash map field could not be resolved.");
            }
            try {
                _FIELD = variablesMap.getDeclaredField("treeMap");
                _FIELD.setAccessible(true);
                VARIABLES_MAP_TREEMAP = _FIELD;
            }
            catch (NoSuchFieldException e) {
                Skript.warning((String)"Skript's tree map field could not be resolved.");
            }
            try {
                Constructor<?> _CONSTRUCTOR = variablesMap.getDeclaredConstructor(new Class[0]);
                _CONSTRUCTOR.setAccessible(true);
                VARIABLES_MAP = _CONSTRUCTOR;
            }
            catch (NoSuchMethodException e) {
                Skript.warning((String)"Skript's variables map constructors could not be resolved.");
            }
        }
        catch (ClassNotFoundException e) {
            Skript.warning((String)"Skript's variables map class could not be resolved.");
        }
        try {
            _FIELD = ClassInfo.class.getDeclaredField("defaultExpression");
            _FIELD.setAccessible(true);
            DEFAULT_EXPRESSION = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's default expression field could not be resolved, therefore event-values won't work in custom events");
        }
        try {
            _FIELD = Option.class.getDeclaredField("parsedValue");
            _FIELD.setAccessible(true);
            PARSED_VALUE = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's parsed value field could not be resolved, therefore and/or warnings won't be suppressed");
        }
    }
}

