/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.reflect.sections;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.util.Kleenean;
import com.btk5h.skriptmirror.SkriptMirror;
import com.btk5h.skriptmirror.skript.reflect.sections.Section;
import com.btk5h.skriptmirror.util.SkriptReflection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EffRunSection
extends Effect {
    private Expression<Section> sectionExpression;
    private boolean runsAsync;
    private List<Expression<?>> arguments;
    private Expression<Object> variableStore;
    private boolean shouldWait;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sectionExpression = SkriptUtil.defendExpression(exprs[0]);
        boolean bl = this.runsAsync = (parseResult.mark & 1) != 0;
        if (this.runsAsync) {
            ScriptLoader.hasDelayBefore = Kleenean.TRUE;
        }
        Expression expr = SkriptUtil.defendExpression(exprs[1]);
        this.arguments = new ArrayList();
        if (expr instanceof ExpressionList) {
            Collections.addAll(this.arguments, ((ExpressionList)expr).getExpressions());
        } else if (expr != null) {
            this.arguments.add(expr);
        }
        this.variableStore = SkriptUtil.defendExpression(exprs[2]);
        if (this.variableStore != null && !(this.variableStore instanceof Variable)) {
            Skript.error((String)"The result can only be stored in a variable");
            return false;
        }
        boolean bl2 = this.shouldWait = (parseResult.mark & 2) != 0;
        if (this.runsAsync && !this.shouldWait && this.variableStore != null) {
            Skript.warning((String)"You need to wait until the section is finished if you want to get a result.");
        }
        return SkriptUtil.canInitSafely(this.variableStore) && (this.arguments.size() == 0 || this.arguments.stream().allMatch(xva$0 -> SkriptUtil.canInitSafely(xva$0)));
    }

    protected TriggerItem walk(Event e) {
        if (this.runsAsync) {
            Section section = (Section)this.sectionExpression.getSingle(e);
            Object[][] args = this.getArgs(e);
            Object localVars = SkriptReflection.removeLocals(e);
            if (section == null) {
                return this.getNext();
            }
            new Thread(() -> {
                SkriptReflection.putLocals(localVars, e);
                section.run(e, args);
                this.storeResult(section, e);
                if (this.shouldWait && this.getNext() != null) {
                    Bukkit.getScheduler().runTask((Plugin)SkriptMirror.getInstance(), () -> {
                        TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
                        SkriptReflection.removeLocals(e);
                    });
                }
            }).start();
            return this.shouldWait ? null : this.getNext();
        }
        return super.walk(e);
    }

    protected void execute(Event e) {
        Section section = (Section)this.sectionExpression.getSingle(e);
        if (section != null) {
            section.run(e, this.getArgs(e));
            this.storeResult(section, e);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "run section " + this.sectionExpression.toString(e, debug);
    }

    private Object[][] getArgs(Event event) {
        Object[][] args = new Object[this.arguments.size()][];
        for (int i = 0; i < this.arguments.size(); ++i) {
            args[i] = this.arguments.get(i).getArray(event);
        }
        return args;
    }

    private void storeResult(Section section, Event event) {
        Object[] output = section.getOutput();
        if (this.variableStore != null) {
            this.variableStore.change(event, output, output == null ? Changer.ChangeMode.DELETE : Changer.ChangeMode.SET);
        }
    }

    static {
        Skript.registerEffect(EffRunSection.class, (String[])new String[]{"run section %section% [(1\u00a6async)] [with [arguments] %-objects%] [and store [the] result in %-objects%] [(2\u00a6and wait)]"});
    }
}

