/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.event;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.Classes;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.event.BukkitCustomEvent;
import com.btk5h.skriptmirror.skript.custom.event.CustomEvent;
import com.btk5h.skriptmirror.skript.custom.event.EventSyntaxInfo;
import com.btk5h.skriptmirror.skript.custom.event.EventTriggerEvent;
import com.btk5h.skriptmirror.util.SkriptReflection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CustomEventSection
extends CustomSyntaxSection<EventSyntaxInfo> {
    private static final CustomSyntaxSection.DataTracker<EventSyntaxInfo> dataTracker;
    private static final String listSplitPattern = "\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*";
    static Map<EventSyntaxInfo, String> nameValues;
    static Map<EventSyntaxInfo, List<ClassInfo<?>>> eventValueTypes;
    static Map<EventSyntaxInfo, Trigger> parserHandlers;
    static Map<EventSyntaxInfo, Trigger> eventHandlers;

    @Override
    protected CustomSyntaxSection.DataTracker<EventSyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        File script = (parseResult.mark & 1) == 1 ? SkriptUtil.getCurrentScript() : null;
        ArrayList<String> patternStrings = new ArrayList<String>();
        SectionNode patternsNode = (SectionNode)node.get("patterns");
        EntryNode patternNode = (EntryNode)node.get("pattern");
        if (patternsNode != null) {
            for (Object subNode : patternsNode) {
                patternStrings.add(subNode.getKey());
            }
        } else if (patternNode != null) {
            patternStrings.add(patternNode.getValue());
        } else {
            Skript.error((String)"You need at least one pattern");
            return false;
        }
        int i = 1;
        for (String pattern : patternStrings) {
            this.register(EventSyntaxInfo.create(script, pattern, i++));
        }
        if (this.whichInfo.size() == 0) {
            Skript.error((String)"You need at least one pattern");
            return false;
        }
        String name = (String)args[0].getSingle();
        if (nameValues.values().stream().anyMatch(name::equalsIgnoreCase)) {
            Skript.error((String)"There is already a custom event with that name");
            return false;
        }
        this.whichInfo.forEach(which -> nameValues.put((EventSyntaxInfo)which, name));
        return CustomEventSection.handleEntriesAndSections(node, entryNode -> {
            String key = entryNode.getKey();
            assert (key != null);
            if (key.equalsIgnoreCase("pattern")) {
                return true;
            }
            if (key.equalsIgnoreCase("event-values")) {
                String[] stringClasses = entryNode.getValue().split(listSplitPattern);
                ArrayList classInfoList = new ArrayList();
                for (String stringClass : stringClasses) {
                    ClassInfo classInfo = Classes.getClassInfoFromUserInput((String)stringClass);
                    if (classInfo == null) {
                        Skript.error((String)("The type " + stringClass + " doesn't exist"));
                        return false;
                    }
                    classInfoList.add(classInfo);
                }
                SkriptReflection.replaceEventValues(classInfoList);
                this.whichInfo.forEach(which -> eventValueTypes.put((EventSyntaxInfo)which, classInfoList));
                return true;
            }
            return false;
        }, sectionNode -> {
            String key = sectionNode.getKey();
            assert (key != null);
            if (key.equalsIgnoreCase("patterns")) {
                return true;
            }
            if (key.equalsIgnoreCase("parse")) {
                SyntaxParseEvent.register(this, sectionNode, this.whichInfo, parserHandlers);
                return true;
            }
            if (key.equalsIgnoreCase("check")) {
                ScriptLoader.setCurrentEvent((String)"custom event trigger", (Class[])new Class[]{EventTriggerEvent.class});
                CustomEvent.lastWhich = (EventSyntaxInfo)this.whichInfo.get(0);
                List<TriggerItem> items = SkriptUtil.getItemsFromNode(sectionNode);
                CustomEvent.lastWhich = null;
                this.whichInfo.forEach(which -> eventHandlers.put((EventSyntaxInfo)which, new Trigger(SkriptUtil.getCurrentScript(), "event " + which, (SkriptEvent)this, items)));
                return true;
            }
            return false;
        });
    }

    public static EventSyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Event", CustomEventSection.class, "[(1\u00a6local)] [custom] event %string%");
        dataTracker = new CustomSyntaxSection.DataTracker();
        nameValues = new HashMap<EventSyntaxInfo, String>();
        eventValueTypes = new HashMap();
        parserHandlers = new HashMap<EventSyntaxInfo, Trigger>();
        eventHandlers = new HashMap<EventSyntaxInfo, Trigger>();
        dataTracker.setSyntaxType("event");
        Skript.registerEvent((String)"custom event", CustomEvent.class, BukkitCustomEvent.class, (String[])new String[0]);
        Optional<SkriptEventInfo> info = Skript.getEvents().stream().filter(i -> i.c == CustomEvent.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(nameValues);
        dataTracker.addManaged(eventValueTypes);
        dataTracker.addManaged(parserHandlers);
        dataTracker.addManaged(eventHandlers);
    }
}

