/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.event;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.event.BukkitCustomEvent;
import com.btk5h.skriptmirror.skript.custom.event.CustomEventSection;
import com.btk5h.skriptmirror.skript.custom.event.EventSyntaxInfo;
import com.btk5h.skriptmirror.skript.custom.event.EventTriggerEvent;
import com.btk5h.skriptmirror.util.SkriptReflection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class CustomEvent
extends SkriptEvent {
    public static EventSyntaxInfo lastWhich;
    private EventSyntaxInfo which;
    private Expression<?>[] exprs;
    private SkriptParser.ParseResult parseResult;
    private Object variablesMap;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.which = CustomEventSection.lookup(SkriptUtil.getCurrentScript(), matchedPattern);
        if (this.which == null) {
            return false;
        }
        this.exprs = (Expression[])Arrays.stream(args).map(SkriptUtil::defendExpression).toArray(Expression[]::new);
        this.parseResult = parseResult;
        if (!SkriptUtil.canInitSafely(this.exprs)) {
            return false;
        }
        lastWhich = this.which;
        Trigger parseHandler = CustomEventSection.parserHandlers.get(this.which);
        if (parseHandler == null) {
            return true;
        }
        SyntaxParseEvent event = new SyntaxParseEvent(this.exprs, matchedPattern, parseResult, ScriptLoader.getCurrentEvents());
        TriggerItem.walk((TriggerItem)parseHandler, (Event)event);
        this.variablesMap = SkriptReflection.removeLocals(event);
        return event.isMarkedContinue();
    }

    public boolean check(Event e) {
        BukkitCustomEvent bukkitCustomEvent = (BukkitCustomEvent)e;
        if (!bukkitCustomEvent.getName().equalsIgnoreCase(CustomEventSection.nameValues.get(this.which))) {
            return false;
        }
        EventTriggerEvent eventTriggerEvent = new EventTriggerEvent(e, this.exprs, this.which.getMatchedPattern(), this.parseResult, this.which.getPattern());
        SkriptReflection.putLocals(SkriptReflection.copyLocals(this.variablesMap), eventTriggerEvent);
        Trigger trigger = CustomEventSection.eventHandlers.get(this.which);
        if (trigger != null) {
            trigger.execute((Event)eventTriggerEvent);
            return eventTriggerEvent.isMarkedContinue();
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.which.getPattern();
    }
}

