/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxEvent;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.event.HandlerList;

public class SyntaxParseEvent
extends CustomSyntaxEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Class<?>[] eventClasses;
    private boolean markedContinue;

    public SyntaxParseEvent(Expression<?>[] expressions, int matchedPattern, SkriptParser.ParseResult parseResult, Class<?>[] eventClasses) {
        super(null, SyntaxParseEvent.wrapRawExpressions(expressions), matchedPattern, parseResult);
        this.eventClasses = eventClasses;
    }

    private static Expression<?>[] wrapRawExpressions(Expression<?>[] expressions) {
        return (Expression[])Arrays.stream(expressions).map(expr -> expr == null ? null : new SimpleLiteral(expr, false)).toArray(Expression[]::new);
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Class<?>[] getEventClasses() {
        return this.eventClasses;
    }

    public boolean isMarkedContinue() {
        return this.markedContinue;
    }

    public void markContinue() {
        this.markedContinue = true;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static <T extends CustomSyntaxSection.SyntaxData> void register(CustomSyntaxSection<T> section, SectionNode parseNode, List<T> whichInfo, Map<T, Trigger> parserHandlers) {
        ScriptLoader.setCurrentEvent((String)"custom syntax parser", (Class[])new Class[]{SyntaxParseEvent.class});
        List<TriggerItem> items = SkriptUtil.getItemsFromNode(parseNode);
        whichInfo.forEach(which -> parserHandlers.put(which, new Trigger(SkriptUtil.getCurrentScript(), "parse " + which.getPattern(), (SkriptEvent)section, items)));
    }
}

