/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.InvalidNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.VoidNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.log.SkriptLogger;
import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.skript.custom.CustomImport;
import com.btk5h.skriptmirror.skript.custom.event.BukkitCustomEvent;
import com.btk5h.skriptmirror.skript.custom.event.CustomEvent;
import com.btk5h.skriptmirror.skript.custom.event.CustomEventUtils;
import com.btk5h.skriptmirror.skript.custom.event.EventSyntaxInfo;
import com.btk5h.skriptmirror.util.SkriptReflection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.event.Event;

public abstract class CustomSyntaxSection<T extends SyntaxData>
extends SelfRegisteringSkriptEvent {
    protected final List<T> whichInfo = new ArrayList<T>();

    public static <E extends SkriptEvent> SkriptEventInfo<E> register(String name, Class<E> c, String ... patterns) {
        return Skript.registerEvent((String)("*" + name), c, (Class[])new Class[0], (String[])patterns);
    }

    protected abstract DataTracker<T> getDataTracker();

    public void register(Trigger t) {
    }

    public void unregister(Trigger t) {
        this.whichInfo.forEach(which -> {
            Map<File, Map<String, T>> primaryData = this.getDataTracker().getPrimaryData();
            File script = which.getScript();
            Map<String, T> syntaxes = primaryData.get(script);
            syntaxes.remove(which.getPattern());
            if (syntaxes.size() == 0) {
                primaryData.remove(script);
            }
            this.getDataTracker().getManagedData().forEach(data -> data.remove(which));
        });
        this.update();
    }

    public void unregisterAll() {
        this.getDataTracker().getPatterns().clear();
        this.getDataTracker().getPrimaryData().clear();
        this.getDataTracker().getManagedData().forEach(Map::clear);
        this.update();
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        SectionNode node = (SectionNode)SkriptLogger.getNode();
        node.convertToEntries(0);
        if (node.getKey().toLowerCase().startsWith("on ")) {
            return false;
        }
        boolean ok = this.init(args, matchedPattern, parseResult, node);
        SkriptUtil.clearSectionNode(node);
        if (!ok) {
            this.unregister(null);
        }
        return ok;
    }

    protected abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3, SectionNode var4);

    protected static boolean handleEntriesAndSections(SectionNode node, Predicate<EntryNode> entryHandler, Predicate<SectionNode> sectionHandler) {
        boolean ok = true;
        for (Node subNode : SkriptReflection.getNodes(node)) {
            SkriptLogger.setNode((Node)subNode);
            if (subNode instanceof EntryNode) {
                if (!entryHandler.test((EntryNode)subNode)) {
                    Skript.error((String)String.format("Unexpected entry '%s'. Check whether it's spelled correctly or remove it.", subNode.getKey()));
                    ok = false;
                }
            } else if (subNode instanceof SectionNode) {
                if (!sectionHandler.test((SectionNode)subNode)) {
                    Skript.error((String)String.format("Unexpected section '%s'. Check whether it's spelled correctly or remove it.", subNode.getKey()));
                    ok = false;
                }
            } else if (subNode instanceof InvalidNode || !(subNode instanceof VoidNode)) {
                ok = false;
            }
            SkriptLogger.setNode(null);
        }
        return ok;
    }

    public String toString(Event e, boolean debug) {
        return null;
    }

    private void update() {
        this.getDataTracker().recomputePatterns();
        SkriptReflection.setPatterns(this.getDataTracker().getInfo(), this.getDataTracker().getPatterns().toArray(new String[0]));
    }

    protected final void register(T data) {
        String pattern = ((SyntaxData)data).getPattern();
        this.whichInfo.add(data);
        this.getDataTracker().getPrimaryData().computeIfAbsent(((SyntaxData)data).getScript(), f -> new HashMap()).put(pattern, data);
        this.update();
    }

    protected boolean handleUsableSection(SectionNode sectionNode, Map<T, List<Supplier<Boolean>>> usableSuppliers) {
        File currentScript = SkriptUtil.getCurrentScript();
        for (Node usableNode : sectionNode) {
            Supplier<Boolean> supplier;
            String usableKey = usableNode.getKey();
            assert (usableKey != null);
            if (usableKey.startsWith("custom event ")) {
                String customEventString = usableKey.substring("custom event ".length());
                VariableString variableString = VariableString.newInstance((String)customEventString.substring(1, customEventString.length() - 1));
                if (variableString == null || !variableString.isSimple()) {
                    Skript.error((String)"Custom event identifiers may only be simple strings");
                    return false;
                }
                String identifier = variableString.toString(null);
                supplier = () -> {
                    if (!ScriptLoader.isCurrentEvent(BukkitCustomEvent.class)) {
                        return false;
                    }
                    EventSyntaxInfo eventWhich = CustomEvent.lastWhich;
                    return CustomEventUtils.getName(eventWhich).equalsIgnoreCase(identifier);
                };
            } else {
                Class<?> javaClass;
                JavaType javaType = CustomImport.lookup(currentScript, usableKey);
                Class<?> clazz = javaClass = javaType == null ? null : javaType.getJavaClass();
                if (javaClass == null || !Event.class.isAssignableFrom(javaClass)) {
                    Skript.error((String)(javaType + " is not a Bukkit event"));
                    return false;
                }
                Class<?> eventClass = javaClass;
                supplier = () -> ScriptLoader.isCurrentEvent((Class)eventClass);
            }
            this.whichInfo.forEach(which -> usableSuppliers.computeIfAbsent(which, whichIndex -> new ArrayList()).add(supplier));
        }
        return true;
    }

    public static abstract class SyntaxData {
        private final File script;
        private final String pattern;
        private final int matchedPattern;

        protected SyntaxData(File script, String pattern, int matchedPattern) {
            this.script = script;
            this.pattern = pattern;
            this.matchedPattern = matchedPattern;
        }

        public File getScript() {
            return this.script;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getMatchedPattern() {
            return this.matchedPattern;
        }

        public String toString() {
            return this.pattern;
        }
    }

    public static class DataTracker<T> {
        private List<String> patterns = new ArrayList<String>();
        private final Map<File, Map<String, T>> primaryData = new HashMap<File, Map<String, T>>();
        private final List<Map<T, ?>> managedData = new ArrayList();
        private String syntaxType = "syntax";
        private SyntaxElementInfo<?> info;

        public List<String> getPatterns() {
            return this.patterns;
        }

        public Map<File, Map<String, T>> getPrimaryData() {
            return this.primaryData;
        }

        public List<Map<T, ?>> getManagedData() {
            return this.managedData;
        }

        public String getSyntaxType() {
            return this.syntaxType;
        }

        public SyntaxElementInfo<?> getInfo() {
            return this.info;
        }

        public void recomputePatterns() {
            this.patterns = this.primaryData.entrySet().stream().map(Map.Entry::getValue).map(Map::keySet).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }

        public void addManaged(Map<T, ?> data) {
            this.managedData.add(data);
        }

        public void setSyntaxType(String syntaxType) {
            this.syntaxType = syntaxType;
        }

        public void setInfo(SyntaxElementInfo<?> info) {
            this.info = info;
        }

        public final T lookup(File script, int matchedPattern) {
            T privateResult;
            String originalSyntax = this.patterns.get(matchedPattern);
            Map<String, T> localSyntax = this.primaryData.get(script);
            if (localSyntax != null && (privateResult = localSyntax.get(originalSyntax)) != null) {
                return privateResult;
            }
            Map<String, T> globalSyntax = this.primaryData.get(null);
            if (globalSyntax == null || !globalSyntax.containsKey(originalSyntax)) {
                return null;
            }
            return globalSyntax.get(originalSyntax);
        }
    }
}

