/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.Event;

public class Consent
extends SelfRegisteringSkriptEvent {
    private static final Map<File, List<Feature>> consentedFeatures;
    private static final String FIRST_CONSENT_LINE = "I understand that the following features are experimental and may change in the future.";
    private static final String[] SECOND_CONSENT_LINE;

    public void register(Trigger t) {
    }

    public void unregister(Trigger t) {
        consentedFeatures.remove(t.getScript());
    }

    public void unregisterAll() {
        consentedFeatures.clear();
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        File currentScript = ScriptLoader.currentScript.getFile();
        SectionNode node = (SectionNode)SkriptLogger.getNode();
        if (node.getKey().toLowerCase().startsWith("on ")) {
            return false;
        }
        int consentLine = 0;
        for (Node subNode : node) {
            String text = subNode.getKey();
            assert (text != null);
            if (consentLine == 0 && !text.equals(FIRST_CONSENT_LINE) || consentLine == 1 && !text.equals(SECOND_CONSENT_LINE[0]) && !text.equals(SECOND_CONSENT_LINE[1])) {
                return false;
            }
            if (consentLine++ < 2) continue;
            Optional<Feature> optionalFeature = Feature.byCodeName(text);
            if (optionalFeature.isPresent()) {
                Feature feature = optionalFeature.get();
                if (feature.isOutdated()) {
                    Skript.warning((String)"This consent feature is no longer needed");
                }
                consentedFeatures.computeIfAbsent(currentScript, t -> new ArrayList()).add(feature);
                continue;
            }
            Skript.error((String)("The feature '" + text + "' doesn't exist or isn't experimental"));
            return false;
        }
        SkriptUtil.clearSectionNode(node);
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "experimental consent notice";
    }

    static {
        CustomSyntaxSection.register("Consent", Consent.class, "skript-(mirror|reflect), I know what I'm doing");
        consentedFeatures = new HashMap<File, List<Feature>>();
        SECOND_CONSENT_LINE = new String[]{"I have read about this at https://skript-mirror.gitbook.io/docs/advanced/experiments", "I have read about this at https://tpgamesnl.gitbook.io/skript-reflect/advanced/experiments"};
    }

    public static enum Feature {
        PROXIES("proxies", true),
        DEFERRED_PARSING("deferred-parsing");

        private final String codeName;
        private final boolean outdated;

        private Feature(String codeName) {
            this(codeName, false);
        }

        private Feature(String codeName, boolean isDeprecated) {
            this.codeName = codeName;
            this.outdated = isDeprecated;
        }

        public boolean hasConsent(File script) {
            List features = (List)consentedFeatures.get(script);
            return features != null && features.contains((Object)this);
        }

        public static Optional<Feature> byCodeName(String codeName) {
            return Arrays.stream(Feature.values()).filter(f -> codeName.equals(f.codeName)).findFirst();
        }

        public boolean isOutdated() {
            return this.outdated;
        }
    }
}

