/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror;

import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.LibraryLoader;
import com.btk5h.skriptmirror.skript.custom.CustomImport;
import com.btk5h.skriptmirror.util.JavaUtil;
import com.btk5h.skriptmirror.util.SkriptMirrorUtil;
import java.io.File;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Descriptor {
    private static final String PACKAGE_ARRAY = "(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)(?:\\[])*";
    private static final Pattern PACKAGE_ARRAY_SINGLE = Pattern.compile("\\[]");
    private static final Pattern DESCRIPTOR = Pattern.compile("(?:\\[((?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*))])?([_a-zA-Z$][\\w$]*)(?:\\[((?:(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)(?:\\[])*\\s*,\\s*)*(?:(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)(?:\\[])*))])?");
    private final Class<?> javaClass;
    private final String name;
    private final Class<?>[] parameterTypes;

    public Descriptor(Class<?> javaClass, String name, Class<?>[] parameterTypes) {
        this.javaClass = javaClass;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return Objects.equals(this.javaClass, that.javaClass) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass, this.name);
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isStatic) {
        return String.format("%s" + (isStatic ? "." : "#") + "%s", this.javaClass == null ? "(unspecified)" : SkriptMirrorUtil.getDebugName(this.javaClass), this.name);
    }

    public Descriptor orDefaultClass(Class<?> cls) {
        if (this.getJavaClass() != null) {
            return this;
        }
        return new Descriptor(cls, this.getName(), this.getParameterTypes());
    }

    public static Descriptor parse(String desc, File script) throws ClassNotFoundException {
        Matcher m = DESCRIPTOR.matcher(desc);
        if (m.matches()) {
            String cls = m.group(1);
            String name = m.group(2);
            String args = m.group(3);
            Class<?> javaClass = null;
            Class<?>[] parameterTypes = null;
            if (cls != null) {
                javaClass = Descriptor.lookupClass(script, cls);
            }
            if (args != null) {
                parameterTypes = Descriptor.parseParams(args, script);
            }
            return new Descriptor(javaClass, name, parameterTypes);
        }
        return null;
    }

    private static Class<?>[] parseParams(String args, File script) throws ClassNotFoundException {
        String[] rawClasses = args.split(",");
        Class[] parsedClasses = new Class[rawClasses.length];
        for (int i = 0; i < rawClasses.length; ++i) {
            String userType = rawClasses[i].trim();
            Matcher arrayDepthMatcher = PACKAGE_ARRAY_SINGLE.matcher(userType);
            int arrayDepth = 0;
            while (arrayDepthMatcher.find()) {
                ++arrayDepth;
            }
            Class<?> cls = JavaUtil.PRIMITIVE_CLASS_NAMES.get(userType = userType.substring(0, userType.length() - 2 * arrayDepth));
            if (cls == null) {
                cls = Descriptor.lookupClass(script, userType);
            }
            parsedClasses[i] = cls = JavaUtil.getArrayClass(cls, arrayDepth);
        }
        return parsedClasses;
    }

    private static Class<?> lookupClass(File script, String userType) throws ClassNotFoundException {
        JavaType customImport = CustomImport.lookup(script, userType);
        if (customImport != null) {
            return customImport.getJavaClass();
        }
        return LibraryLoader.getClassLoader().loadClass(userType);
    }
}

