/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvent;
import org.bukkit.event.Event;

@Name(value="Placeholder Result")
@Description(value={"The value of a placeholder in a placeholder event. Can be set, reset, or deleted."})
@Examples(value={"on placeholderapi placeholder request for the prefix \"custom\":", "\tif the identifier is \"hello\": # Placeholder is \"%custom_hey%\"", "\t\tset the result to \"Hey there %player%!\"", "on mvdw placeholder request for the placeholder \"custom_hey\":", "\t# Placeholder is \"{custom_hey}\"", "\tset the result to \"Hey there %player%!\""})
@Since(value="1.0 - PlaceholderAPI | 1.3 - MVdWPlaceholderAPI")
@Events(value={"Placeholder Request"})
public class ExprPlaceholderResult
extends SimpleExpression<String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(PlaceholderEvent.class)) {
            Skript.error((String)"The placeholder result can only be used in a placeholder request event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        return new String[]{((PlaceholderEvent)e).getResult()};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null && mode == Changer.ChangeMode.SET) {
            return;
        }
        switch (mode) {
            case SET: {
                ((PlaceholderEvent)e).setResult((String)delta[0]);
                break;
            }
            case RESET: 
            case DELETE: {
                ((PlaceholderEvent)e).setResult(null);
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                assert (false);
                break;
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the placeholder result";
    }

    static {
        Skript.registerExpression(ExprPlaceholderResult.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [[event(-| )]placeholder] result"});
    }
}

