/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvent;
import org.bukkit.event.Event;

@Name(value="Placeholder")
@Description(value={"Returns the placeholder in a placeholder request event."})
@Examples(value={"on placeholderapi placeholder request for the prefix \"custom\":", "\tbroadcast \"Placeholder: %the placeholder%\"", "\tbroadcast \"Prefix: %the placeholder prefix%\"", "\tbroadcast \"Identifier: %the placeholder identifier%\"", "on mvdw placeholder request for the placeholder \"custom_hey\":", "\tbroadcast \"Placeholder: %the placeholder%\""})
@Since(value="1.0 - PlaceholderAPI | 1.3 - MVdWPlaceholderAPI")
@Events(value={"Placeholder Request"})
public class ExprPlaceholder
extends SimpleExpression<String> {
    private int placeholderPart;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(PlaceholderEvent.class)) {
            Skript.error((String)"The placeholder can only be used in a placeholder request event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.placeholderPart = parseResult.mark;
        return true;
    }

    protected String[] get(Event e) {
        switch (this.placeholderPart) {
            case 0: {
                return new String[]{((PlaceholderEvent)e).getPlaceholder()};
            }
            case 1: {
                return new String[]{((PlaceholderEvent)e).getPrefix()};
            }
            case 2: {
                return new String[]{((PlaceholderEvent)e).getIdentifier()};
            }
        }
        return new String[0];
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        switch (this.placeholderPart) {
            case 0: {
                return "the placeholder";
            }
            case 1: {
                return "the placeholder prefix";
            }
            case 2: {
                return "the placeholder identifier";
            }
        }
        return "placeholder";
    }

    static {
        Skript.registerExpression(ExprPlaceholder.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [event(-| )]placeholder", "[the] [[event(-| )]placeholder] (1\u00a6prefix|2\u00a6identifier)"});
    }
}

