/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptplaceholders.skript.util.PlaceholderUtils;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Value of Placeholder")
@Description(value={"Returns the value of a PlaceholderAPI/MVdWPlaceholderAPI placeholder.", "Note: The 'without color' option is only applicable for PlaceholderAPI placeholders."})
@Examples(value={"command /ping <player>:", "\ttrigger:", "\t\tset {_ping} to placeholder \"player_ping\" from arg-1 # PlaceholderAPI", "\t\tset {_ping} to placeholder \"{ping}\" from arg-1 # MVdWPlaceholderAPI", "\t\tsend \"Ping of %arg-1%: %{_ping}%\" to player"})
@Since(value="1.0 - PAPI Placeholders | 1.2 - MVdW Placeholders | 1.3 - Updated Syntax | 1.4 - Colorize Option")
public class ExprParsePlaceholder
extends SimpleExpression<String> {
    private Expression<String> placeholders;
    private Expression<OfflinePlayer> players;
    private boolean colorize;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.placeholders = exprs[0];
        this.players = exprs[1];
        this.colorize = parseResult.mark != 1;
        return true;
    }

    protected String[] get(Event e) {
        ArrayList<String> values = new ArrayList<String>();
        String[] placeholders = (String[])this.placeholders.getArray(e);
        if (this.players != null) {
            Object[] players = this.players.getArray(e);
            for (String placeholder : placeholders) {
                for (Object player : players) {
                    if (!(player instanceof OfflinePlayer)) continue;
                    values.add(PlaceholderUtils.getPlaceholder(placeholder, (OfflinePlayer)player, this.colorize));
                }
            }
        } else {
            for (String placeholder : placeholders) {
                values.add(PlaceholderUtils.getPlaceholder(placeholder, null, this.colorize));
            }
        }
        return values.toArray(new String[0]);
    }

    public boolean isSingle() {
        return this.players != null ? this.placeholders.isSingle() && this.players.isSingle() : this.placeholders.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        if (this.players != null) {
            return "the value of placeholder(s) " + this.placeholders.toString(e, debug) + " from " + this.players.toString(e, debug);
        }
        return "the value of placeholder(s) " + this.placeholders.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprParsePlaceholder.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] ([value of] placeholder[s]|placeholder [value] [of]) %strings% [(from|of) %-players/offlineplayers%] [(1\u00a6without color)]", "parse placeholder[s] %strings% [(for|as) %-players/offlineplayers%] [(1\u00a6without color)]"});
    }
}

