/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.skript.elements.events;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import io.github.apickledwalrus.skriptplaceholders.SkriptPlaceholders;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvent;
import io.github.apickledwalrus.skriptplaceholders.placeholder.mvdwplaceholderapi.MVdWPlaceholderAPIListener;
import io.github.apickledwalrus.skriptplaceholders.placeholder.placeholderapi.PlaceholderAPIListener;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Placeholder Request Event")
@Description(value={"Called whenever a placeholder is requested by a supported placeholder plugin."})
@Examples(value={"on placeholderapi placeholder request for the prefix \"custom\":", "\tif the identifier is \"hello\": # Placeholder is \"%custom_hey%\"", "\t\tset the result to \"Hey there %player%!\"", "on mvdw placeholder request for the placeholder \"custom_hey\":", "\t# Placeholder is \"{custom_hey}\"", "\tset the result to \"Hey there %player%!\""})
@Since(value="1.0 - PlaceholderAPI | 1.3 - MVdWPlaceholderAPI | 2.0 - New Event Features")
public class EvtPlaceholderRequest
extends SkriptEvent {
    private String[] placeholders;
    private int pattern;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        switch (matchedPattern) {
            case 0: {
                if (SkriptPlaceholders.hasPapi()) break;
                Skript.error((String)"PlaceholderAPI is required to register PlaceholderAPI placeholders.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            case 1: {
                if (SkriptPlaceholders.hasPapi()) break;
                Skript.error((String)"MVdWPlaceholderAPI is required to register MVdWPlaceholderAPI placeholders.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        for (Literal<?> literal : args) {
            String placeholder = (String)literal.getSingle();
            if (StringUtils.isBlank((String)placeholder)) {
                Skript.error((String)(placeholder + " is not a valid placeholder"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            placeholders.add(placeholder);
        }
        if (placeholders.isEmpty()) {
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                for (String placeholder : placeholders) {
                    new PlaceholderAPIListener((Plugin)SkriptPlaceholders.getInstance(), placeholder).register();
                }
                break;
            }
            case 1: {
                for (String placeholder : placeholders) {
                    new MVdWPlaceholderAPIListener((Plugin)SkriptPlaceholders.getInstance(), placeholder).register();
                }
                break;
            }
        }
        this.placeholders = placeholders.toArray(new String[0]);
        this.pattern = matchedPattern;
        return true;
    }

    public boolean check(Event e) {
        String eventPlaceholder = "";
        switch (this.pattern) {
            case 0: {
                eventPlaceholder = ((PlaceholderEvent)e).getPrefix();
                break;
            }
            case 1: {
                eventPlaceholder = ((PlaceholderEvent)e).getPlaceholder();
            }
        }
        if (eventPlaceholder.equals("")) {
            return false;
        }
        for (String placeholder : this.placeholders) {
            if (!eventPlaceholder.equalsIgnoreCase(placeholder)) continue;
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event e, boolean debug) {
        String placeholders = Arrays.toString(this.placeholders);
        placeholders = placeholders.substring(1, placeholders.length() - 1);
        switch (this.pattern) {
            case 0: {
                return "placeholderapi placeholder request for the prefixes " + placeholders;
            }
            case 1: {
                return "mvdwplaceholderapi placeholder request for the placeholders " + placeholders;
            }
        }
        return "placeholder request event";
    }

    static {
        Skript.registerEvent((String)"Placeholder Request", EvtPlaceholderRequest.class, PlaceholderEvent.class, (String[])new String[]{"(placeholder[ ]api|papi) [placeholder] request (for|with) [the] prefix[es] %strings%", "mvdw[ ](placeholder[ ]api [placeholder]|placeholder) request (for|with) [the] placeholder[es] %strings%"});
        EventValues.registerEventValue(PlaceholderEvent.class, Player.class, (Getter)new Getter<Player, PlaceholderEvent>(){

            public Player get(PlaceholderEvent e) {
                if (e.getPlayer().isOnline()) {
                    return (Player)e.getPlayer();
                }
                return null;
            }
        }, (int)0);
        EventValues.registerEventValue(PlaceholderEvent.class, OfflinePlayer.class, (Getter)new Getter<OfflinePlayer, PlaceholderEvent>(){

            public OfflinePlayer get(PlaceholderEvent e) {
                return e.getPlayer();
            }
        }, (int)0);
    }
}

