/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.placeholderaddon.skript.expressions;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.placeholderaddon.Main;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Value of Placeholder")
@Description(value={"Returns the value of a PlaceholderAPI/MVdWPlaceholderAPI placeholder.", "Note: The 'without color' option is only applicable for PlaceholderAPI placeholders."})
@Examples(value={"command /ping <player>:", "\ttrigger:", "\t\tset {_ping} to placeholder \"player_ping\" from arg-1 # PlaceholderAPI", "\t\tset {_ping} to placeholder \"{ping}\" from arg-1 # MVdWPlaceholderAPI", "\t\tsend \"Ping of %arg-1%: %{_ping}%\" to player"})
@Since(value="1.0 - PAPI Placeholders, 1.2 - MVdW Placeholders, 1.3 - Updated Syntax, 1.4 - Colorize Option")
public class ExprParsePlaceholder
extends SimpleExpression<String> {
    private Expression<String> placeholders;
    private Expression<OfflinePlayer> players;
    private boolean colorize;

    private String formatPlaceholder(String placeholder) {
        if (placeholder == null) {
            return null;
        }
        if (placeholder.charAt(0) == '%') {
            placeholder = placeholder.substring(1);
        }
        if (placeholder.charAt(placeholder.length() - 1) == '%') {
            placeholder = placeholder.substring(0, placeholder.length() - 1);
        }
        return "%" + placeholder + "%";
    }

    private String getPlaceholder(String placeholder, OfflinePlayer player) {
        if (Main.hasMVdW() && placeholder.charAt(0) == '{' && placeholder.charAt(placeholder.length() - 1) == '}') {
            String value = PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)placeholder);
            return value.equals(placeholder) ? null : value;
        }
        if (Main.hasPapi() && me.clip.placeholderapi.PlaceholderAPI.containsPlaceholders((String)(placeholder = this.formatPlaceholder(placeholder)))) {
            String value = player != null && player.isOnline() ? me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)((Player)player), (String)placeholder, (!this.colorize ? 1 : 0) != 0) : me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)placeholder, (!this.colorize ? 1 : 0) != 0);
            if (value == null || value.isEmpty() || value.equalsIgnoreCase(placeholder)) {
                return null;
            }
            return value;
        }
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.placeholders = exprs[0];
        this.players = exprs[1];
        this.colorize = parseResult.mark == 1;
        return true;
    }

    protected String[] get(Event e) {
        ArrayList<String> values = new ArrayList<String>();
        String[] placeholders = (String[])this.placeholders.getArray(e);
        if (this.players == null) {
            for (String pl : placeholders) {
                values.add(this.getPlaceholder(pl, null));
            }
        } else {
            OfflinePlayer[] players = (OfflinePlayer[])this.players.getArray(e);
            for (String pl : placeholders) {
                for (OfflinePlayer p : players) {
                    values.add(this.getPlaceholder(pl, p));
                }
            }
        }
        return values.toArray(new String[0]);
    }

    public boolean isSingle() {
        return this.players != null ? this.placeholders.isSingle() && this.players.isSingle() : this.placeholders.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the value of placeholder(s) " + this.placeholders.toString(e, debug) + " from " + this.players.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprParsePlaceholder.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] ([value of] placeholder[s]|placeholder [value] [of]) %strings% [from %-players/offlineplayers%] [(1\u00a6without color)]", "parse placeholder[s] %strings% [(for|as) %-players/offlineplayers%] [(1\u00a6without color)]"});
    }
}

