/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.placeholderaddon.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.placeholderaddon.Main;
import io.github.apickledwalrus.placeholderaddon.mvdwapi.MvdwAPIEvent;
import org.bukkit.event.Event;

@Name(value="MVdWPlaceholderAPI Placeholder")
@Description(value={"Returns the placeholder in a MVdWPlaceholderAPI request event."})
@Examples(value={"on mvdw placeholder request for placeholder \"doublehealth\":", "\tsend \"MVdWPlaceholderAPI requested the placeholder %placeholder%!\" to console"})
@Since(value="1.3")
public class ExprMvdwPlaceholder
extends SimpleExpression<String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(MvdwAPIEvent.class)) {
            Skript.error((String)"The MVdWPlaceholderAPI placeholder can only be used in a MVdWPlaceholderAPI request event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        return new String[]{((MvdwAPIEvent)e).getPlaceholder()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the mvdwplaceholderapi prefix";
    }

    static {
        if (Main.hasMVdW()) {
            Skript.registerExpression(ExprMvdwPlaceholder.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [mvdw[ ][placeholder[api]]] placeholder"});
        }
    }
}

