/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.placeholderaddon.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import io.github.apickledwalrus.placeholderaddon.Main;
import io.github.apickledwalrus.placeholderaddon.placeholderapi.PlaceholderAPIEvent;
import io.github.apickledwalrus.placeholderaddon.placeholderapi.PlaceholderAPIListener;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="PlaceholderAPI Placeholder Request Event")
@Description(value={"Called whenever a placeholder is requested by PlaceholderAPI."})
@Examples(value={"on placeholderapi request with prefix \"double\":", "\tif the identifier is \"health\": # The placeholder is double_health", "\t\tset the result to player's health * 2 "})
@Since(value="1.0")
public class EvtPapiPlaceholderRequest
extends SkriptEvent {
    private String prefix;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.prefix = (String)args[0].getSingle();
        if ("".equals(this.prefix)) {
            Skript.error((String)(this.prefix + " is not a valid placeholder"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        new PlaceholderAPIListener(Main.getInstance(), this.prefix).register();
        return true;
    }

    public boolean check(Event e) {
        return ((PlaceholderAPIEvent)e).getPrefix().equalsIgnoreCase(this.prefix);
    }

    public String toString(Event e, boolean debug) {
        return "placeholder request" + (this.prefix != null ? "with prefix \"" + this.prefix + "\"" : "");
    }

    static {
        if (Main.hasPapi()) {
            Skript.registerEvent((String)"Placeholder Request", EvtPapiPlaceholderRequest.class, PlaceholderAPIEvent.class, (String[])new String[]{"(placeholderapi|papi) [placeholder] request (with|for) [the] prefix %string%"});
            EventValues.registerEventValue(PlaceholderAPIEvent.class, Player.class, (Getter)new Getter<Player, PlaceholderAPIEvent>(){

                public Player get(PlaceholderAPIEvent e) {
                    return e.getPlayer();
                }
            }, (int)0);
        }
    }
}

