/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.placeholderaddon.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import io.github.apickledwalrus.placeholderaddon.Main;
import io.github.apickledwalrus.placeholderaddon.mvdwapi.MvdwAPIEvent;
import io.github.apickledwalrus.placeholderaddon.mvdwapi.MvdwAPIListener;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@Name(value="MVdWPlaceholderAPI Placeholder Request Event")
@Description(value={"Called whenever a placeholder is requested by MVdWPlaceholderAPI."})
@Examples(value={"on mvdw placeholder request for placeholder \"doublehealth\":", "\tset the result to player's health * 2"})
@Since(value="1.3")
public class EvtMvdwPlaceholderRequest
extends SkriptEvent {
    private String placeholder;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.placeholder = (String)args[0].getSingle();
        if ("".equals(this.placeholder)) {
            Skript.error((String)(this.placeholder + " is not a valid placeholder"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        MvdwAPIListener.registerPlaceholder((Plugin)Main.getInstance(), this.placeholder);
        return true;
    }

    public boolean check(Event e) {
        return ((MvdwAPIEvent)e).getPlaceholder().equalsIgnoreCase(this.placeholder);
    }

    public String toString(Event e, boolean debug) {
        return "placeholder request" + (this.placeholder != null ? "with placeholder \"" + this.placeholder + "\"" : "");
    }

    static {
        if (Main.hasMVdW()) {
            Skript.registerEvent((String)"Placeholder Request", EvtMvdwPlaceholderRequest.class, MvdwAPIEvent.class, (String[])new String[]{"mvdw[ ](placeholderapi placeholder|placeholder) request (for|with) [the] placeholder %string%"});
            EventValues.registerEventValue(MvdwAPIEvent.class, Player.class, (Getter)new Getter<Player, MvdwAPIEvent>(){

                public Player get(MvdwAPIEvent e) {
                    return e.getPlayer();
                }
            }, (int)0);
        }
    }
}

