/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.placeholderaddon.skript.expressions;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.placeholderaddon.Main;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Value of Placeholder")
@Description(value={"Returns the value of a PlaceholderAPI/MVdWPlaceholderAPI placeholder."})
@Examples(value={"command /ping <player>:", "\ttrigger:", "\t\tset {_ping} to placeholder \"player_ping\" from arg-1 # PlaceholderAPI", "\t\tset {_ping} to placeholder \"{ping}\" from arg-1 # MVdWPlaceholderAPI", "\t\tsend \"Ping of %arg-1%: %{_ping}%\" to player"})
@Since(value="1.0 - PAPI Placeholders, 1.2 - MVdW Placeholders, 1.3 - Updated Syntax")
public class ExprParsePlaceholder
extends SimpleExpression<String> {
    private Expression<String> placeholders;
    private Expression<Player> players;

    private String formatPlaceholder(String placeholder) {
        if (placeholder == null) {
            return null;
        }
        if (placeholder.charAt(0) == '%') {
            placeholder = placeholder.substring(1);
        }
        if (placeholder.charAt(placeholder.length() - 1) == '%') {
            placeholder = placeholder.substring(0, placeholder.length() - 1);
        }
        return "%" + placeholder + "%";
    }

    private String getPlaceholder(String placeholder, Player player) {
        if (Main.hasMVdW() && placeholder.charAt(0) == '{' && placeholder.charAt(placeholder.length() - 1) == '}') {
            String value = PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)placeholder);
            if (value.equals(placeholder)) {
                return null;
            }
            return value;
        }
        if (Main.hasPapi() && me.clip.placeholderapi.PlaceholderAPI.containsPlaceholders((String)(placeholder = this.formatPlaceholder(placeholder)))) {
            String value = me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
            if (value == null || value.equals(placeholder)) {
                return null;
            }
            return value;
        }
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.placeholders = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected String[] get(Event e) {
        String[] placeholders = (String[])this.placeholders.getArray(e);
        Player[] players = (Player[])this.players.getArray(e);
        ArrayList<String> values = new ArrayList<String>();
        if (players.length != 0) {
            for (String pl : placeholders) {
                for (Player p : players) {
                    values.add(this.getPlaceholder(pl, p));
                }
            }
        } else {
            for (String pl : placeholders) {
                values.add(this.getPlaceholder(pl, null));
            }
        }
        return values.toArray(new String[0]);
    }

    public boolean isSingle() {
        return this.placeholders.isSingle() && this.players.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the value of placeholder " + this.placeholders.toString(e, debug) + " from " + this.players.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprParsePlaceholder.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] ([value of] placeholder[s]|placeholder [value] [of]) %strings% [from %players%]", "parse placeholder[s] %strings% [(for|as) %players%]"});
    }
}

