/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.placeholderaddon.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.apickledwalrus.placeholderaddon.Main;
import io.github.apickledwalrus.placeholderaddon.mvdwapi.MvdwAPIEvent;
import org.bukkit.event.Event;

@Name(value="MVdWPlaceholderAPI Result")
@Description(value={"The result (placeholder value) in a MVdWPlaceholderAPI request event. It can be set or reset/deleted."})
@Examples(value={"on mvdw placeholder request for placeholder \"isAdmin\":", "\tset the result to \"false\"", "\tif player has permission \"is.admin\":", "\t\tset the result to \"true\""})
@Since(value="1.3")
public class ExprMvdwResult
extends SimpleExpression<String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(MvdwAPIEvent.class)) {
            Skript.error((String)"The MVdWPlaceholderAPI result can only be used in a MVdWPlaceholderAPI request event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        return new String[]{((MvdwAPIEvent)e).getResult()};
    }

    public String toString(Event e, boolean debug) {
        return "the mvdwplaceholderapi result";
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                ((MvdwAPIEvent)e).setResult(String.valueOf(delta[0]));
                break;
            }
            case RESET: 
            case DELETE: {
                ((MvdwAPIEvent)e).setResult(null);
            }
        }
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        if (Main.hasMVdW()) {
            Skript.registerExpression(ExprMvdwResult.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [mvdw[ ][placeholder[api]]] result"});
        }
    }
}

