/*
 * Decompiled with CFR 0.152.
 */
package me.wheezygold.skriptping.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import me.wheezygold.skriptping.SKU;
import me.wheezygold.skriptping.SkriptPing;
import org.bukkit.event.Event;

@Name(value="Server Version String")
@Description(value={"The name of the server version."})
@Examples(value={"set the version string to \"SkriptCord\""})
@Since(value="0.1")
@SKU.data(name="Server Version String", desc="The name of the server version.", example="set the version string to \"SkriptCord\"")
public class ExprVersionString
extends SimpleExpression<String> {
    protected String[] get(Event e) {
        return new String[]{SkriptPing.getInstance().getCustomVersionName()};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (delta[0] == null) {
                Skript.error((String)"Version string must be a valid string!");
                return;
            }
            SkriptPing.getInstance().setCustomVersionName((String)delta[0]);
        } else {
            SkriptPing.getInstance().setCustomVersionName(null);
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "version string";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    static {
        Skript.registerExpression(ExprVersionString.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] version (string|name)"});
    }
}

