/*
 * Decompiled with CFR 0.152.
 */
package me.wheezygold.skriptping.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import me.wheezygold.skriptping.SKU;
import me.wheezygold.skriptping.SkriptPing;
import org.bukkit.event.Event;

@Name(value="Set Server Icon (Base64)")
@Description(value={"Set's the server's icon from base 64 code."})
@Examples(value={"set the server-icon to base64 \"*base 64 code*\""})
@Since(value="0.1")
@SKU.data(name="Set Server Icon (Base64)", desc="Set's the server's icon from base 64 code.", example="set the server-icon to base64 \"*base 64 code*\"")
public class EffSetIcon64
extends Effect {
    private Expression<String> baseString;

    protected void execute(Event e) {
        try {
            byte[] imgBytes = Base64.getDecoder().decode((String)this.baseString.getSingle(e));
            BufferedImage image = this.toBufferedImage(ImageIO.read(new ByteArrayInputStream(imgBytes)).getScaledInstance(64, 64, 1));
            SkriptPing.getInstance().setServerIcon(WrappedServerPing.CompressedImage.fromPng((RenderedImage)image));
        }
        catch (IOException | IllegalArgumentException e1) {
            Skript.error((String)"Unable to decode your base-64 string!");
            e1.printStackTrace();
        }
    }

    public String toString(Event e, boolean debug) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.baseString = exprs[0];
        return true;
    }

    private BufferedImage toBufferedImage(Image image) {
        BufferedImage buffer = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = buffer.createGraphics();
        g.drawImage(image, null, null);
        return buffer;
    }

    static {
        Skript.registerEffect(EffSetIcon64.class, (String[])new String[]{"set [the] server(-| )icon to base64 %string%"});
    }
}

