/*
 * Decompiled with CFR 0.152.
 */
package me.wheezygold.skriptping.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import me.wheezygold.skriptping.SKU;
import me.wheezygold.skriptping.SkriptPing;
import org.bukkit.event.Event;

@Name(value="Set Server Icon (Image File)")
@Description(value={"Set's the server's icon"})
@Examples(value={"set the server-icon to image at file \"test.png\""})
@Since(value="0.1")
@SKU.data(name="Set Server Icon (Image File)", desc="Set's the server's icon", example="set the server-icon to image at file \"test.png\"")
public class EffSetIcon
extends Effect {
    private Expression<String> fileString;

    protected void execute(Event e) {
        BufferedImage image;
        if (!((String)this.fileString.getSingle(e)).endsWith(".png")) {
            Skript.error((String)"Icon file must be a png!");
            return;
        }
        File file = new File((String)this.fileString.getSingle(e));
        if (!file.exists()) {
            Skript.error((String)"Icon file does exist!");
            return;
        }
        try {
            image = this.toBufferedImage(ImageIO.read(file).getScaledInstance(64, 64, 1));
        }
        catch (IOException e1) {
            Skript.error((String)"Unable to access file!");
            e1.printStackTrace();
            return;
        }
        try {
            SkriptPing.getInstance().setServerIcon(WrappedServerPing.CompressedImage.fromPng((RenderedImage)image));
        }
        catch (IOException e1) {
            Skript.error((String)"Unable to set server icon!");
            e1.printStackTrace();
        }
    }

    private BufferedImage toBufferedImage(Image image) {
        BufferedImage buffer = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = buffer.createGraphics();
        g.drawImage(image, null, null);
        return buffer;
    }

    public String toString(Event e, boolean debug) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fileString = exprs[0];
        return true;
    }

    static {
        Skript.registerEffect(EffSetIcon.class, (String[])new String[]{"set [the] server(-| )icon to [image at] file %string%"});
    }
}

