/*
 * Decompiled with CFR 0.152.
 */
package me.wheezygold.skriptping;

import ch.njol.skript.Skript;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.wheezygold.skripthack.SkriptHack;
import me.wheezygold.skriptping.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptPing
extends JavaPlugin {
    private static SkriptPing instance;
    private List<String> hoverListStrings = new ArrayList<String>();
    private String customVersionName = "";
    private String customMotd = "";
    private WrappedServerPing.CompressedImage serverIcon = null;
    private PluginManager pluginManager = this.getServer().getPluginManager();

    public void onEnable() {
        this.log(C.cDAqua + "Loading skript-ping!");
        instance = this;
        if (this.pluginManager.getPlugin("Skript") != null) {
            if (this.pluginManager.getPlugin("ProtocolLib") != null) {
                this.log(C.cDAqua + "Loading Metrics...");
                Metrics metrics = new Metrics(this);
                metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Bukkit.getServer().getPluginManager().getPlugin("Skript").getDescription().getVersion()));
                this.log(C.cDAqua + "Loading Syntax...");
                if (this.loadSkript()) {
                    this.log(C.cDAqua + "Loading Ping Listener!");
                    this.initListener();
                }
            } else {
                this.log(C.cDRed + "This plugin also requires ProtocolLib to work, please download it and restart your server!");
            }
        } else {
            this.log(C.cDRed + "This plugin is a Skript Addon so therefore it requires Skript to be enabled!");
        }
    }

    private boolean loadSkript() {
        boolean isPost = false;
        if (!Skript.isAcceptRegistrations()) {
            isPost = true;
            if (this.pluginManager.getPlugin("skript-hack") == null) {
                this.log(C.cPurple + "Skript is not accepting registrations currently! To load syntax without restarting your server get skript-hack at: https://tinyurl.com/skript-hack");
                return false;
            }
            try {
                SkriptHack.enableRegistrations();
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.log(C.cPurple + "Error while skript-hack'ing into your syntax! Please restart your server!");
                return false;
            }
        }
        try {
            Skript.registerAddon((JavaPlugin)this).loadClasses("me.wheezygold.skriptping", new String[]{"skript"});
        }
        catch (IOException e) {
            this.log(C.cDRed + "Skript was unable to register this addon and load our syntax. Please report this!");
            return false;
        }
        if (isPost) {
            try {
                SkriptHack.disableRegistrations();
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.log(C.cPurple + "Error while skript-hack'ing into your syntax! Please restart your server!");
                return false;
            }
        }
        return true;
    }

    private void initListener() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)this, ListenerPriority.NORMAL, Collections.singletonList(PacketType.Status.Server.OUT_SERVER_INFO), new ListenerOptions[]{ListenerOptions.ASYNC}){

            public void onPacketSending(PacketEvent event) {
                WrappedServerPing ping = (WrappedServerPing)event.getPacket().getServerPings().read(0);
                if (!SkriptPing.this.hoverListStrings.isEmpty()) {
                    int count = 0;
                    ArrayList<WrappedGameProfile> hoverList = new ArrayList<WrappedGameProfile>();
                    for (String curString : SkriptPing.this.hoverListStrings) {
                        hoverList.add(new WrappedGameProfile(String.valueOf(count), ChatColor.translateAlternateColorCodes((char)'&', (String)curString)));
                        ++count;
                    }
                    ping.setPlayers(hoverList);
                }
                if (!SkriptPing.this.customVersionName.isEmpty()) {
                    ping.setVersionName(SkriptPing.this.customVersionName);
                }
                if (!SkriptPing.this.customMotd.isEmpty()) {
                    ping.setMotD(ChatColor.translateAlternateColorCodes((char)'&', (String)SkriptPing.this.customMotd));
                }
                if (SkriptPing.this.serverIcon != null) {
                    ping.setFavicon(SkriptPing.this.serverIcon);
                }
            }
        });
    }

    public static SkriptPing getInstance() {
        return instance;
    }

    public List<String> getHoverListStrings() {
        return this.hoverListStrings;
    }

    public void setCustomVersionName(String customVersionName) {
        this.customVersionName = customVersionName;
    }

    public void setCustomMotd(String customMotd) {
        this.customMotd = customMotd;
    }

    public void setServerIcon(WrappedServerPing.CompressedImage icon) {
        this.serverIcon = icon;
    }

    public void resetIcon() {
        this.serverIcon = null;
    }

    private void log(String message) {
        this.getServer().getConsoleSender().sendMessage("[skript-ping] " + message);
    }

    public static class C {
        static String Error = "\u00c2\u00a7k";
        static String Bold = "\u00c2\u00a7l";
        static String Strike = "\u00c2\u00a7m";
        static String BoldStrike = "\u00c2\u00a7l\u00c2\u00a7m";
        static String NewLine = "\u00c2\u00a7n";
        static String Italics = "\u00c2\u00a7o";
        static String cAqua = "" + ChatColor.AQUA;
        static String cBlack = "" + ChatColor.BLACK;
        static String cBlue = "" + ChatColor.BLUE;
        static String cDAqua = "" + ChatColor.DARK_AQUA;
        static String cDBlue = "" + ChatColor.DARK_BLUE;
        static String cDGray = "" + ChatColor.DARK_GRAY;
        static String cDGreen = "" + ChatColor.DARK_GREEN;
        static String cDPurple = "" + ChatColor.DARK_PURPLE;
        static String cDRed = "" + ChatColor.DARK_RED;
        static String cGold = "" + ChatColor.GOLD;
        static String cGray = "" + ChatColor.GRAY;
        static String cGreen = "" + ChatColor.GREEN;
        static String cPurple = "" + ChatColor.LIGHT_PURPLE;
        static String cRed = "" + ChatColor.RED;
        static String cWhite = "" + ChatColor.WHITE;
        static String cYellow = "" + ChatColor.YELLOW;
    }
}

