/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Entity Citizen")
@Description(value={"Returns the citizen of an entity."})
@Examples(value={"set {_x} to the citizen of target entity"})
@Since(value="0.1")
public class ExprEntityCitizen
extends SimpleExpression<SkriptCitizen> {
    private Expression<Entity> entity;

    protected SkriptCitizen[] get(Event event) {
        return new SkriptCitizen[]{new SkriptCitizen(CitizensAPI.getNPCRegistry().getNPC((Entity)this.entity.getSingle(event)))};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends SkriptCitizen> getReturnType() {
        return SkriptCitizen.class;
    }

    public String toString(Event event, boolean b) {
        return "citizen of an entity";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entity = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprEntityCitizen.class, SkriptCitizen.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (citizen|npc) of %entity%", "[the] %entity%'s (citizen|npc)"});
    }
}

