/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name(value="Citizen Vulnerability")
@Description(value={"Returns the vulnerability of a citizen."})
@Examples(value={"set {_x} to npc vulnerability of the last citizen"})
@Since(value="0.1")
public class ExprCitizenVulnerability
extends SimpleExpression<Boolean> {
    private Expression<SkriptCitizen> citizen;

    protected Boolean[] get(Event event) {
        if (this.citizen.getSingle(event) != null) {
            return new Boolean[]{((SkriptCitizen)this.citizen.getSingle(event)).getNpc().isProtected()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public String toString(Event event, boolean b) {
        return "vulnerability of a citizen";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        return true;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                ((SkriptCitizen)this.citizen.getSingle(e)).getNpc().setProtected(((Boolean)delta[0]).booleanValue());
                break;
            }
            case DELETE: 
            case RESET: {
                ((SkriptCitizen)this.citizen.getSingle(e)).getNpc().setProtected(false);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprCitizenVulnerability.class, Boolean.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (citizen|npc) vulnerability of %citizen%", "[the] %citizen%'s (citizen|npc) vulnerability"});
    }
}

