/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import org.bukkit.event.Event;

@Name(value="Citizen Skin")
@Description(value={"Returns a citizen's skin name"})
@Examples(value={"set {_x} to the npc skin of last citizen"})
@Since(value="0.1")
public class ExprCitizenSkin
extends SimpleExpression<String> {
    private Expression<SkriptCitizen> citizen;

    protected String[] get(Event event) {
        if (this.citizen.getSingle(event) != null && ((SkriptCitizen)this.citizen.getSingle(event)).getNpc().isSpawned()) {
            SkinnableEntity skinnableEntity = (SkinnableEntity)((SkriptCitizen)this.citizen.getSingle(event)).getNpc().getEntity();
            return new String[]{skinnableEntity.getSkinName()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "skin name of a citizen";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        return true;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                SkinnableEntity skinnableEntity = (SkinnableEntity)((SkriptCitizen)this.citizen.getSingle(e)).getNpc().getEntity();
                skinnableEntity.setSkinName((String)delta[0]);
                break;
            }
            case RESET: 
            case DELETE: {
                SkinnableEntity skinnableEntity = (SkinnableEntity)((SkriptCitizen)this.citizen.getSingle(e)).getNpc().getEntity();
                skinnableEntity.setSkinName("Steve");
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprCitizenSkin.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (citizen|npc) skin [name] of %citizen%", "[the] %citizen%'s (citizen|npc) skin [name]"});
    }
}

