/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name(value="Citizen Name")
@Description(value={"Returns a citizen's name"})
@Examples(value={"set {_x} to the npc name of the last citizen"})
@Since(value="0.1")
public class ExprCitizenName
extends SimpleExpression<String> {
    private Expression<SkriptCitizen> citizen;

    protected String[] get(Event event) {
        if (this.citizen.getSingle(event) != null) {
            return new String[]{((SkriptCitizen)this.citizen.getSingle(event)).getNpc().getName()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "name of a citizen";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        return true;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                ((SkriptCitizen)this.citizen.getSingle(e)).getNpc().setName((String)delta[0]);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprCitizenName.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (citizen|npc) name of %citizen%", "[the] %citizen%'s (citizen|npc) name"});
    }
}

