/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name(value="Citizen ID")
@Description(value={"Returns the ID of a citizen."})
@Examples(value={"set {_x} to npc id of the last citizen"})
@Since(value="0.1")
public class ExprCitizenId
extends SimpleExpression<Number> {
    private Expression<SkriptCitizen> citizen;

    protected Number[] get(Event event) {
        return new Number[]{((SkriptCitizen)this.citizen.getSingle(event)).getId()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return "npc id of a citizen";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprCitizenId.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(citizen|npc) id of %citizen%", "%citizen%'s (citizen|npc) id"});
    }
}

