/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Citizen Entity")
@Description(value={"Returns the entity of a citizen"})
@Examples(value={"set {_x} to the npc entity of the last citizen"})
@Since(value="0.1")
public class ExprCitizenEntity
extends SimpleExpression<Entity> {
    private Expression<SkriptCitizen> citizen;

    protected Entity[] get(Event event) {
        if (this.citizen.getSingle(event) != null && ((SkriptCitizen)this.citizen.getSingle(event)).getNpc().isSpawned()) {
            return new Entity[]{((SkriptCitizen)this.citizen.getSingle(event)).getNpc().getEntity()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public String toString(Event event, boolean b) {
        return "entity of a citizen";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprCitizenEntity.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (citizen|npc) entity of %citizen%", "[the] %citizen%'s (citizen|npc) entity"});
    }
}

