/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import net.citizensnpcs.api.ai.Navigator;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Move Citizen")
@Description(value={"Makes a citizen move to a specific location with optional speed."})
@Examples(value={"make the last citizen move to player's location at speed 2"})
@Since(value="0.1")
public class EffMoveCitizen
extends Effect {
    private Expression<SkriptCitizen> citizen;
    private Expression<Location> location;
    private Expression<Number> speed;

    protected void execute(Event event) {
        if (this.citizen.getSingle(event) != null && this.location.getSingle(event) != null) {
            Number moveSpeed = this.speed != null ? (Number)((Number)this.speed.getSingle(event)) : (Number)1;
            Navigator nav = ((SkriptCitizen)this.citizen.getSingle(event)).getNpc().getNavigator();
            nav.cancelNavigation();
            nav.getDefaultParameters().baseSpeed(moveSpeed.floatValue());
            nav.setTarget((Location)this.location.getSingle(event));
        }
    }

    public String toString(Event event, boolean b) {
        return "make a citizen travel to a location with optional speed";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        this.location = expressions[1];
        this.speed = expressions[2];
        return true;
    }

    static {
        Skript.registerEffect(EffMoveCitizen.class, (String[])new String[]{"make %citizen% (go|move|travel) to [the] %location% [(at|with) speed %-number%]"});
    }
}

