/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name(value="Citizen Is Navigating")
@Description(value={"Checks if a citizen is navigating."})
@Examples(value={"if the last citizen is navigating:"})
@Since(value="0.1")
public class CondIsNavigating
extends Condition {
    private Expression<SkriptCitizen> citizen;

    public boolean check(Event event) {
        return this.citizen.getSingle(event) != null && ((SkriptCitizen)this.citizen.getSingle(event)).getNpc().getNavigator().isNavigating();
    }

    public String toString(Event event, boolean b) {
        return "a citizen is navigating";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        return true;
    }

    static {
        Skript.registerCondition(CondIsNavigating.class, (String[])new String[]{"[the] %citizen% (is (navigating|moving)|has [a] navigation)"});
    }
}

