/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import io.github.nanodankster.skriptnpc.util.Metrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptNPC
extends JavaPlugin {
    private SkriptNPC instance;
    private SkriptAddon addonInstance;
    private FileConfiguration config;
    private File configFile;

    public SkriptNPC() {
        if (this.instance != null) {
            throw new IllegalStateException();
        }
        this.instance = this;
    }

    public void onEnable() {
        this.getLogger().info("skript-npc is warming up...");
        this.saveMyConfig();
        this.loadMyConfig();
        if (this.getServer().getPluginManager().getPlugin("Skript") != null) {
            if (this.config.getBoolean("enable-metrics")) {
                Metrics metrics = new Metrics(this.getInstance());
                metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> this.getServer().getPluginManager().getPlugin("Skript").getDescription().getVersion()));
                this.getLogger().info("Metrics are enabled.");
            } else {
                this.getLogger().info("Metrics are disabled, please enable them!");
            }
            if (Skript.isAcceptRegistrations()) {
                try {
                    this.getAddonInstance().loadClasses("io.github.nanodankster.skriptnpc", new String[]{"skript"});
                    this.getLogger().info("Loaded all addon classes.");
                }
                catch (IOException e) {
                    this.getLogger().severe("Cannot load the addon classes to Skript!");
                    e.printStackTrace();
                }
            } else {
                this.getLogger().severe("Skript is not accepting registrations!");
            }
        } else {
            this.getLogger().severe("Cannot find Skript!");
        }
        this.getLogger().info("Finished loading.");
    }

    private void saveMyConfig() {
        File file;
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
            this.getLogger().warning("Cannot create the plugin folder!");
        }
        if (!(file = new File(this.getDataFolder() + "\\config.yml")).exists()) {
            try {
                Files.copy(this.getResource("config.yml"), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.getLogger().info("Cannot create the configuration file!");
                e.printStackTrace();
            }
        }
        this.configFile = file;
    }

    private void loadMyConfig() {
        if (this.configFile != null && this.configFile.exists()) {
            this.config = new YamlConfiguration();
            try {
                this.config.load(this.configFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private SkriptAddon getAddonInstance() {
        if (this.addonInstance == null) {
            this.addonInstance = Skript.registerAddon((JavaPlugin)this.getInstance());
        }
        return this.addonInstance;
    }

    private SkriptNPC getInstance() {
        if (this.instance == null) {
            throw new IllegalStateException();
        }
        return this.instance;
    }
}

