/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.SkriptNPC;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name(value="Citizen Vulnerability")
@Description(value={"Returns the vulnerability of a citizen. Can be set and reset to true."})
@Examples(value={"set vulnerability of the last npc to false"})
@Since(value="0.1.1")
public class ExprPropCitizenVulnerability
extends SimplePropertyExpression<SkriptCitizen, Boolean> {
    protected String getPropertyName() {
        return "vulnerability of citizen";
    }

    public Boolean convert(SkriptCitizen skriptCitizen) {
        if (skriptCitizen != null) {
            return skriptCitizen.getNpc().isProtected();
        }
        return null;
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                Boolean changeTo = (Boolean)delta[0];
                ((SkriptCitizen)this.getExpr().getSingle(e)).getNpc().setProtected(changeTo.booleanValue());
                break;
            }
            case RESET: {
                ((SkriptCitizen)this.getExpr().getSingle(e)).getNpc().setProtected(true);
            }
        }
    }

    static {
        SkriptNPC.registerPropExpr(ExprPropCitizenVulnerability.class, Boolean.class, "[npc] vulnerability", "citizen");
    }
}

