/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.event.Event;

@Name(value="Citizen from ID")
@Description(value={"Returns a citizen from its ID."})
@Examples(value={"set {_x} to the citizen from id 1"})
@Since(value="0.1")
public class ExprCitizenFromId
extends SimpleExpression<SkriptCitizen> {
    private Expression<Number> id;

    protected SkriptCitizen[] get(Event event) {
        if (this.id.getSingle(event) != null && CitizensAPI.getNPCRegistry().getById(((Number)this.id.getSingle(event)).intValue()) != null) {
            SkriptCitizen citizen = new SkriptCitizen(CitizensAPI.getNPCRegistry().getById(((Number)this.id.getSingle(event)).intValue()));
            return new SkriptCitizen[]{citizen};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends SkriptCitizen> getReturnType() {
        return SkriptCitizen.class;
    }

    public String toString(Event event, boolean b) {
        return "a citizen from id";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprCitizenFromId.class, SkriptCitizen.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (citizen|npc) (with|from) id[entifier] %number%"});
    }
}

