/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;

@Name(value="Create Citizen")
@Description(value={"Creates a citizen with name, type and optional location."})
@Examples(value={"create npc named \"Nano\" with type player at player's location"})
@Since(value="0.1")
public class EffCreateCitizen
extends Effect {
    private Expression<String> name;
    private Expression<ch.njol.skript.entity.EntityType> type;
    private Expression<Location> location;

    protected void execute(Event event) {
        if (this.name.getSingle(event) != null && this.type.getSingle(event) != null) {
            NPC npc = CitizensAPI.getNPCRegistry().createNPC(this.convert(((ch.njol.skript.entity.EntityType)this.type.getSingle(event)).toString()), (String)this.name.getSingle(event));
            if (this.location != null && this.location.getSingle(event) != null) {
                npc.spawn((Location)this.location.getSingle(event));
            }
            SkriptCitizen.setLastCitizen(new SkriptCitizen(npc, this.convert(((ch.njol.skript.entity.EntityType)this.type.getSingle(event)).toString())));
        }
    }

    public String toString(Event event, boolean b) {
        return "create a citizen with name, type and optional location";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.name = expressions[0];
        this.type = expressions[1];
        this.location = expressions[2];
        return true;
    }

    private EntityType convert(String type) {
        return EntityType.valueOf((String)type.toUpperCase().replace(" ", "_").trim());
    }

    static {
        Skript.registerEffect(EffCreateCitizen.class, (String[])new String[]{"create [a] (citizen|npc) [(named|with name)] %string% [and] [with] [entity] type %entitytype% [at %-location%]"});
    }
}

