/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import net.citizensnpcs.api.ai.Navigator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Citizen Attack/Follow")
@Description(value={"Makes a citizen attack or follow an entity."})
@Examples(value={"make the last citizen follow player", "make the last citizen attack player"})
@Since(value="0.1")
public class EffCitizenAttack
extends Effect {
    private Expression<SkriptCitizen> citizen;
    private Expression<LivingEntity> entity;
    private Boolean attack = true;

    protected void execute(Event event) {
        if (this.citizen.getSingle(event) != null && this.entity.getSingle(event) != null) {
            Navigator nav = ((SkriptCitizen)this.citizen.getSingle(event)).getNpc().getNavigator();
            nav.cancelNavigation();
            nav.setTarget((Entity)this.entity.getSingle(event), this.attack.booleanValue());
        }
    }

    public String toString(Event event, boolean b) {
        return "make a citizen attack/follow an entity";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.citizen = expressions[0];
        this.entity = expressions[1];
        if (parseResult.mark == 1) {
            this.attack = false;
        }
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenAttack.class, (String[])new String[]{"make %citizen% (0\u00a6attack|1\u00a6follow) %livingentity%"});
    }
}

