/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.util;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.util.Pair;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnumClassInfo<E extends Enum<?>> {
    private Class<E> eClass;
    private String codeName;
    private List<Map.Entry<String, E>> pairings = new ArrayList<Map.Entry<String, E>>();

    public EnumClassInfo(Class<E> eClass, String codeName) {
        this.eClass = eClass;
        this.codeName = codeName;
        for (Enum value : (Enum[])eClass.getEnumConstants()) {
            this.pairings.add(0, (Map.Entry<String, Pair>)new Pair((Object)value.toString(), (Object)value));
        }
    }

    public ClassInfo<E> getClassInfo() {
        return new ClassInfo(this.eClass, this.codeName).user(new String[]{this.codeName + "s?"}).parser(this.getParser(true)).serializer(this.getSerializer());
    }

    private Parser<E> getParser(Boolean stringEdited) {
        if (stringEdited.booleanValue()) {
            return new Parser<E>(){

                public E parse(String s, ParseContext context) {
                    s = s.toUpperCase().replace(" ", "_").replace("\u0130", "I");
                    for (Map.Entry pairing : EnumClassInfo.this.pairings) {
                        if (!s.equals(pairing.getKey())) continue;
                        return (Enum)pairing.getValue();
                    }
                    return null;
                }

                public String toString(E e, int i) {
                    return ((Enum)e).toString();
                }

                public String toVariableNameString(E e) {
                    return ((Enum)e).toString();
                }

                public String getVariableNamePattern() {
                    return ".+";
                }
            };
        }
        return new Parser<E>(){

            public E parse(String s, ParseContext context) {
                for (Map.Entry pairing : EnumClassInfo.this.pairings) {
                    if (!s.equals(pairing.getKey())) continue;
                    return (Enum)pairing.getValue();
                }
                return null;
            }

            public String toString(E e, int i) {
                return ((Enum)e).toString();
            }

            public String toVariableNameString(E e) {
                return ((Enum)e).toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        };
    }

    private Serializer<E> getSerializer() {
        return new Serializer<E>(){

            public Fields serialize(E e) {
                Fields fields = new Fields();
                fields.putObject("value", (Object)EnumClassInfo.this.toString());
                return fields;
            }

            public void deserialize(E e, Fields fields) {
                throw new UnsupportedOperationException();
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }

            public E deserialize(Fields fields) throws StreamCorruptedException {
                for (Map.Entry pairing : EnumClassInfo.this.pairings) {
                    if (!fields.getObject("value").equals(pairing.getKey())) continue;
                    return (Enum)pairing.getValue();
                }
                return null;
            }
        };
    }
}

