/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.SkriptNPC;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name(value="Citizen Name")
@Description(value={"Returns the name of a citizen. Can be set and reset to its ID."})
@Examples(value={"set name of the last npc to \"Nano\""})
@Since(value="0.1.1")
public class ExprPropCitizenName
extends SimplePropertyExpression<SkriptCitizen, String> {
    protected String getPropertyName() {
        return "name of citizen";
    }

    public String convert(SkriptCitizen skriptCitizen) {
        if (skriptCitizen != null) {
            return skriptCitizen.getNpc().getName();
        }
        return null;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (this.getExpr().getSingle(e) == null) break;
                ((SkriptCitizen)this.getExpr().getSingle(e)).getNpc().setName((String)delta[0]);
                break;
            }
            case RESET: {
                if (this.getExpr().getSingle(e) == null) break;
                ((SkriptCitizen)this.getExpr().getSingle(e)).getNpc().setName(String.valueOf(((SkriptCitizen)this.getExpr().getSingle(e)).getNpc().getId()));
            }
        }
    }

    static {
        SkriptNPC.registerPropExpr(ExprPropCitizenName.class, String.class, "name", "citizen");
    }
}

