/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import io.github.nanodankster.skriptnpc.SkriptNPC;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.entity.Entity;

@Name(value="Citizen Entity")
@Description(value={"Returns the entity of a citizen. Cannot be changed."})
@Examples(value={"if entity of the last citizen is entity of event-citizen:"})
@Since(value="0.1.1")
public class ExprPropCitizenEntity
extends SimplePropertyExpression<SkriptCitizen, Entity> {
    protected String getPropertyName() {
        return "entity of citizen";
    }

    public Entity convert(SkriptCitizen skriptCitizen) {
        if (skriptCitizen != null && skriptCitizen.getNpc().isSpawned()) {
            return skriptCitizen.getNpc().getEntity();
        }
        return null;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    static {
        SkriptNPC.registerPropExpr(ExprPropCitizenEntity.class, Entity.class, "npc entity", "citizen");
    }
}

