/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Entity Is Citizen")
@Description(value={"Checks if an entity is a citizen."})
@Examples(value={"if target entity is a citizen:"})
@Since(value="0.1.1")
public class CondIsCitizen
extends Condition {
    private Expression<Entity> entity;

    public boolean check(Event event) {
        return this.entity.getSingle(event) != null && CitizensAPI.getNPCRegistry().getNPC((Entity)this.entity.getSingle(event)) != null;
    }

    public String toString(Event event, boolean b) {
        return null;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entity = expressions[0];
        return true;
    }

    static {
        Skript.registerCondition(CondIsCitizen.class, (String[])new String[]{"%entity% is [a] (citizen|npc)"});
    }
}

