/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.variables.Variables;
import com.btk5h.skriptmirror.InsertingHandlerList;
import com.btk5h.skriptmirror.NoMissingAndOrLogger;
import com.btk5h.skriptmirror.util.JavaReflection;
import com.btk5h.skriptmirror.util.JavaUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.event.Event;

public class SkriptReflection {
    public static String MISSING_AND_OR;
    private static Field PATTERNS;
    private static Field PARAMETERS;
    private static Field HANDLERS;
    private static Field CURRENT_OPTIONS;
    private static Field LOCAL_VARIABLES;
    private static Field VARIABLES_MAP_HASHMAP;
    private static Field VARIABLES_MAP_TREEMAP;
    private static Constructor VARIABLES_MAP;

    public static void setPatterns(SyntaxElementInfo<?> info, String[] patterns) {
        try {
            PATTERNS.set(info, patterns);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Parameter<?>[] getParameters(Function function) {
        try {
            return (Parameter[])PARAMETERS.get(function);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static void printLog(RetainingLogHandler logger) {
        HandlerList handler;
        logger.stop();
        try {
            handler = (HandlerList)HANDLERS.get(logger);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        Iterator handlers = handler.iterator();
        ArrayList<LogHandler> parseLogs = new ArrayList<LogHandler>();
        while (handlers.hasNext()) {
            LogHandler nextHandler = (LogHandler)handlers.next();
            if (nextHandler instanceof NoMissingAndOrLogger) continue;
            if (!(nextHandler instanceof ParseLogHandler)) break;
            parseLogs.add(nextHandler);
        }
        parseLogs.forEach(LogHandler::stop);
        SkriptLogger.logAll((Collection)logger.getLog());
    }

    public static Map<String, String> getCurrentOptions() {
        try {
            return (Map)CURRENT_OPTIONS.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static boolean hasLocalVariables(Event e) {
        try {
            return ((Map)LOCAL_VARIABLES.get(null)).containsKey(e);
        }
        catch (IllegalAccessException ex) {
            return false;
        }
    }

    public static void copyVariablesMap(Event from, Event to) {
        if (from == null) {
            return;
        }
        try {
            Map localVariables = (Map)LOCAL_VARIABLES.get(null);
            Object originalVariablesMap = localVariables.get(from);
            if (originalVariablesMap != null) {
                Object variablesMap = localVariables.computeIfAbsent(to, JavaUtil.propagateErrors(e -> VARIABLES_MAP.newInstance(new Object[0])));
                ((Map)VARIABLES_MAP_HASHMAP.get(variablesMap)).putAll((Map)VARIABLES_MAP_HASHMAP.get(originalVariablesMap));
                ((Map)VARIABLES_MAP_TREEMAP.get(variablesMap)).putAll((Map)VARIABLES_MAP_TREEMAP.get(originalVariablesMap));
            }
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
    }

    public static void replaceSkriptLogger() {
        try {
            HANDLERS.set(null, (Object)new InsertingHandlerList((LogHandler)new NoMissingAndOrLogger()));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static {
        Field _FIELD;
        try {
            _FIELD = SkriptParser.class.getDeclaredField("MISSING_AND_OR");
            _FIELD.setAccessible(true);
            MISSING_AND_OR = (String)_FIELD.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        try {
            _FIELD = SyntaxElementInfo.class.getDeclaredField("patterns");
            _FIELD.setAccessible(true);
            PATTERNS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's pattern info field could not be resolved. Custom syntax will not work.");
        }
        try {
            _FIELD = Function.class.getDeclaredField("parameters");
            _FIELD.setAccessible(true);
            PARAMETERS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's parameters field could not be resolved. Class proxies will not work.");
        }
        try {
            _FIELD = SkriptLogger.class.getDeclaredField("handlers");
            _FIELD.setAccessible(true);
            JavaReflection.removeFinalModifier(_FIELD);
            HANDLERS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's handlers field could not be resolved. Some Skript warnings may not be available.");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        try {
            _FIELD = ScriptLoader.class.getDeclaredField("currentOptions");
            _FIELD.setAccessible(true);
            CURRENT_OPTIONS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's options field could not be resolved.");
        }
        try {
            _FIELD = Variables.class.getDeclaredField("localVariables");
            _FIELD.setAccessible(true);
            LOCAL_VARIABLES = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's local variables field could not be resolved.");
        }
        try {
            Class<?> variablesMap = Class.forName("ch.njol.skript.variables.VariablesMap");
            try {
                _FIELD = variablesMap.getDeclaredField("hashMap");
                _FIELD.setAccessible(true);
                VARIABLES_MAP_HASHMAP = _FIELD;
            }
            catch (NoSuchFieldException e) {
                Skript.warning((String)"Skript's hash map field could not be resolved.");
            }
            try {
                _FIELD = variablesMap.getDeclaredField("treeMap");
                _FIELD.setAccessible(true);
                VARIABLES_MAP_TREEMAP = _FIELD;
            }
            catch (NoSuchFieldException e) {
                Skript.warning((String)"Skript's tree map field could not be resolved.");
            }
            try {
                Constructor<?> _CONSTRUCTOR = variablesMap.getDeclaredConstructor(new Class[0]);
                _CONSTRUCTOR.setAccessible(true);
                VARIABLES_MAP = _CONSTRUCTOR;
            }
            catch (NoSuchMethodException e) {
                Skript.warning((String)"Skript's variables map constructors could not be resolved.");
            }
        }
        catch (ClassNotFoundException e) {
            Skript.warning((String)"Skript's variables map class could not be resolved.");
        }
    }
}

