/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.reflect;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.btk5h.skriptmirror.Descriptor;
import com.btk5h.skriptmirror.JavaCallException;
import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.LRUCache;
import com.btk5h.skriptmirror.Null;
import com.btk5h.skriptmirror.ObjectWrapper;
import com.btk5h.skriptmirror.util.JavaUtil;
import com.btk5h.skriptmirror.util.SkriptMirrorUtil;
import com.btk5h.skriptmirror.util.SkriptUtil;
import com.btk5h.skriptmirror.util.StringSimilarity;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.event.Event;

public class ExprJavaCall<T>
implements Expression<T> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final Object[] NO_ARGS = new Object[0];
    private static final Descriptor CONSTRUCTOR_DESCRIPTOR = new Descriptor(null, "<init>", null);
    private static final String LITE_DESCRIPTOR = "[^!(]*[^!(\\s]";
    static Throwable lastError;
    private LRUCache<Descriptor, Collection<MethodHandle>> callSiteCache = new LRUCache(8);
    private File script;
    private boolean suppressErrors;
    private CallType type;
    private Descriptor staticDescriptor;
    private Expression<String> dynamicDescriptor;
    private Expression<Object> rawTarget;
    private Expression<Object> rawArgs;
    private final ExprJavaCall<?> source;
    private final Class<? extends T>[] types;
    private final Class<T> superType;

    public ExprJavaCall() {
        this(null, Object.class);
    }

    @SafeVarargs
    private ExprJavaCall(ExprJavaCall<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.script = source.script;
            this.suppressErrors = source.suppressErrors;
            this.type = source.type;
            this.staticDescriptor = source.staticDescriptor;
            this.dynamicDescriptor = source.dynamicDescriptor;
            this.rawTarget = source.rawTarget;
            this.rawArgs = source.rawArgs;
        }
        this.types = types;
        this.superType = Utils.getSuperType((Class[])types);
    }

    public T getSingle(Event e) {
        Object target = ObjectWrapper.unwrapIfNecessary(this.rawTarget.getSingle(e));
        if (target == null) {
            return null;
        }
        Object[] arguments = this.rawArgs != null ? (this.rawArgs instanceof ExpressionList && this.rawArgs.getAnd() ? Arrays.stream(((ExpressionList)this.rawArgs).getExpressions()).map(SkriptUtil.unwrapWithEvent(e)).map(SkriptMirrorUtil::reifyIfNull).toArray(Object[]::new) : (this.rawArgs.isSingle() ? new Object[]{this.rawArgs.getSingle(e)} : this.rawArgs.getArray(e))) : NO_ARGS;
        return this.invoke(target, arguments, this.getDescriptor(e));
    }

    public T[] getArray(Event e) {
        T returnValue = this.getSingle(e);
        if (returnValue == null) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
        Object[] arr = (Object[])Array.newInstance(this.superType, 1);
        arr[0] = returnValue;
        return arr;
    }

    public T[] getAll(Event e) {
        return this.getArray(e);
    }

    public boolean isSingle() {
        return true;
    }

    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)negated, (boolean)this.getAnd());
    }

    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)false, (boolean)this.getAnd());
    }

    @SafeVarargs
    public final <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprJavaCall<R>(this, to);
    }

    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    public boolean getAnd() {
        return true;
    }

    public boolean setTime(int time) {
        return false;
    }

    public int getTime() {
        return 0;
    }

    public boolean isDefault() {
        return false;
    }

    public Iterator<? extends T> iterator(Event e) {
        return new ArrayIterator((Object[])this.getAll(e));
    }

    public boolean isLoopOf(String s) {
        return false;
    }

    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Expression<? extends T> simplify() {
        return this;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.type == CallType.FIELD && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE)) {
            return new Class[]{Object.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object target = ObjectWrapper.unwrapIfNecessary(this.rawTarget.getSingle(e));
        if (target == null) {
            return;
        }
        Object[] args = new Object[1];
        switch (mode) {
            case SET: {
                args[0] = delta[0];
                break;
            }
            case DELETE: {
                args[0] = Null.getInstance();
            }
        }
        this.invoke(target, args, this.getDescriptor(e));
    }

    public String toString(Event e, boolean debug) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.script = SkriptUtil.getCurrentScript();
        this.suppressErrors = (parseResult.mark & 2) == 2;
        this.rawTarget = SkriptUtil.defendExpression(exprs[0]);
        this.rawArgs = SkriptUtil.defendExpression(exprs[matchedPattern == 0 ? 2 : 1]);
        if (!SkriptUtil.canInitSafely(this.rawTarget, this.rawArgs)) {
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.type = (parseResult.mark & 1) == 1 ? CallType.METHOD : CallType.FIELD;
                this.dynamicDescriptor = exprs[1];
                break;
            }
            case 1: {
                this.type = (parseResult.mark & 1) == 1 ? CallType.METHOD : CallType.FIELD;
                String desc = ((MatchResult)parseResult.regexes.get(0)).group();
                try {
                    this.staticDescriptor = Descriptor.parse(desc, this.script);
                    if (this.staticDescriptor == null) {
                        Skript.error((String)(desc + " is not a valid descriptor."));
                        return false;
                    }
                    if (this.staticDescriptor.getJavaClass() != null && this.getCallSite(this.staticDescriptor).size() == 0) {
                        Skript.error((String)(desc + " refers to a non-existent method/field."));
                        return false;
                    }
                    break;
                }
                catch (ClassNotFoundException e) {
                    Skript.error((String)(desc + " refers to a non-existent class."));
                    return false;
                }
            }
            case 2: {
                this.type = CallType.CONSTRUCTOR;
                this.staticDescriptor = CONSTRUCTOR_DESCRIPTOR;
            }
        }
        return true;
    }

    private void error(Throwable error, String message) {
        lastError = error;
        this.directError(message);
    }

    private void error(String message) {
        lastError = new JavaCallException(message);
        this.directError(message);
    }

    private void directError(String message) {
        if (!this.suppressErrors) {
            Skript.warning((String)message);
        }
    }

    private boolean hasDynamicDescriptor() {
        return this.staticDescriptor == null;
    }

    private Collection<MethodHandle> getCallSite(Descriptor e) {
        return this.callSiteCache.computeIfAbsent(e, this::createCallSite);
    }

    private Collection<MethodHandle> createCallSite(Descriptor e) {
        Class<?> javaClass = e.getJavaClass();
        switch (this.type) {
            case FIELD: {
                return JavaUtil.fields(javaClass).filter(f -> f.getName().equals(e.getName())).peek(f -> f.setAccessible(true)).flatMap(JavaUtil.propagateErrors(f -> Stream.of(LOOKUP.unreflectGetter((Field)f), LOOKUP.unreflectSetter((Field)f)))).filter(Objects::nonNull).limit(2L).collect(Collectors.toList());
            }
            case METHOD: {
                Stream<Method> methodStream = JavaUtil.methods(javaClass).filter(m -> m.getName().equals(e.getName()));
                if (e.getParameterTypes() != null) {
                    methodStream = methodStream.filter(m -> Arrays.equals(m.getParameterTypes(), e.getParameterTypes()));
                }
                return methodStream.peek(m -> m.setAccessible(true)).map(JavaUtil.propagateErrors(LOOKUP::unreflect)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case CONSTRUCTOR: {
                return JavaUtil.constructors(javaClass).peek(c -> c.setAccessible(true)).map(JavaUtil.propagateErrors(LOOKUP::unreflectConstructor)).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    private T invoke(Object target, Object[] arguments, Descriptor baseDescriptor) {
        Object converted;
        if (baseDescriptor == null) {
            return null;
        }
        Object returnedValue = null;
        Class<?> targetClass = SkriptMirrorUtil.toClassUnwrapJavaTypes(target);
        Descriptor descriptor = baseDescriptor.orDefaultClass(targetClass);
        if (!descriptor.getJavaClass().isAssignableFrom(targetClass)) {
            this.error(String.format("Incompatible %s call: %s on %s", new Object[]{this.type, descriptor, SkriptMirrorUtil.getDebugName(targetClass)}));
            return null;
        }
        Object[] argumentsCopy = target instanceof JavaType ? ExprJavaCall.createStaticArgumentsCopy(arguments) : ExprJavaCall.createInstanceArgumentsCopy(target, arguments);
        Optional<MethodHandle> method = this.findCompatibleMethod(descriptor, argumentsCopy);
        if (!method.isPresent()) {
            this.error(String.format("No matching %s: %s%s", new Object[]{this.type, descriptor, this.argumentsMessage(arguments)}));
            this.suggestParameters(descriptor);
            this.suggestTypo(descriptor);
            return null;
        }
        MethodHandle mh = method.get();
        argumentsCopy = ExprJavaCall.convertTypes(mh, argumentsCopy);
        try {
            returnedValue = mh.invokeWithArguments(argumentsCopy);
        }
        catch (Throwable throwable) {
            this.error(throwable, String.format("%s %s%s threw a %s: %s%n", new Object[]{this.type, descriptor, this.argumentsMessage(arguments), throwable.getClass().getSimpleName(), throwable.getMessage()}));
        }
        if (returnedValue == null) {
            return null;
        }
        if (this.superType == Object.class || this.superType == ObjectWrapper.class) {
            returnedValue = ObjectWrapper.wrapIfNecessary(returnedValue, this.superType == ObjectWrapper.class);
        }
        if ((converted = Converters.convert((Object)returnedValue, (Class[])this.types)) == null) {
            String toClasses = Arrays.stream(this.types).map(SkriptMirrorUtil::getDebugName).collect(Collectors.joining(", "));
            this.error(String.format("%s %s%s returned %s, which could not be converted to %s", new Object[]{this.type, descriptor, this.argumentsMessage(arguments), ExprJavaCall.argumentsToString(returnedValue), toClasses}));
            return null;
        }
        lastError = null;
        return (T)converted;
    }

    private Descriptor getDescriptor(Event e) {
        if (this.hasDynamicDescriptor()) {
            String desc = (String)this.dynamicDescriptor.getSingle(e);
            if (desc == null) {
                this.error(String.format("Dynamic descriptor %s returned null", this.dynamicDescriptor.toString(e, false)));
                return null;
            }
            try {
                Descriptor parsedDescriptor = Descriptor.parse(desc, this.script);
                if (parsedDescriptor == null) {
                    this.error(String.format("Invalid dynamic descriptor %s (%s)", this.dynamicDescriptor.toString(e, false), desc));
                    return null;
                }
                return parsedDescriptor;
            }
            catch (ClassNotFoundException ex) {
                this.error(ex, String.format("Class could not be found while parsing the dynamic descriptor %s (%s)", this.dynamicDescriptor.toString(e, false), desc));
                return null;
            }
        }
        return this.staticDescriptor;
    }

    private static Object[] createStaticArgumentsCopy(Object[] args) {
        return Arrays.copyOf(args, args.length);
    }

    private static Object[] createInstanceArgumentsCopy(Object target, Object[] arguments) {
        Object[] copy = new Object[arguments.length + 1];
        copy[0] = target;
        System.arraycopy(arguments, 0, copy, 1, arguments.length);
        return copy;
    }

    private Optional<MethodHandle> findCompatibleMethod(Descriptor descriptor, Object[] args) {
        return this.getCallSite(descriptor).stream().filter(mh -> ExprJavaCall.matchesArgs(args, mh)).findFirst();
    }

    private static boolean matchesArgs(Object[] args, MethodHandle mh) {
        MethodType mt = mh.type();
        Class<?>[] params = mt.parameterArray();
        int varargsIndex = params.length - 1;
        boolean hasVarargs = mh.isVarargsCollector();
        if (!(args.length == params.length || hasVarargs && args.length >= varargsIndex)) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            boolean loopAtVarargs = hasVarargs && i >= varargsIndex;
            Class<?> param = loopAtVarargs ? params[varargsIndex].getComponentType() : params[i];
            Object arg = ObjectWrapper.unwrapIfNecessary(args[i]);
            if (ExprJavaCall.canCoerceType(arg, param) || loopAtVarargs && args.length == params.length && ExprJavaCall.canCoerceType(arg, params[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean canCoerceType(Object o, Class<?> to) {
        if (to.isInstance(o)) {
            return true;
        }
        if (o instanceof Number && JavaUtil.NUMERIC_CLASSES.contains(to)) {
            return true;
        }
        if (to.isArray() && JavaUtil.getArrayDepth(to) == JavaUtil.getArrayDepth(o.getClass())) {
            Class<?> paramComponent = JavaUtil.getBaseComponent(to);
            Class<?> argComponent = JavaUtil.getBaseComponent(o.getClass());
            if (JavaUtil.isNumericClass(paramComponent) && JavaUtil.isNumericClass(argComponent)) {
                return true;
            }
        }
        if (to.isPrimitive() && JavaUtil.WRAPPER_CLASSES.get(to).isInstance(o)) {
            return true;
        }
        if (o instanceof String && (to == Character.TYPE || to == Character.class) && ((String)o).length() == 1) {
            return true;
        }
        if (to == Class.class && (o instanceof JavaType || o instanceof ClassInfo)) {
            return true;
        }
        return !to.isPrimitive() && o instanceof Null;
    }

    private static Object[] convertTypes(MethodHandle mh, Object[] args) {
        Class<?>[] params = mh.type().parameterArray();
        int varargsIndex = params.length - 1;
        boolean hasVarargs = mh.isVarargsCollector();
        for (int i = 0; i < args.length; ++i) {
            boolean loopAtVarargs = hasVarargs && i >= varargsIndex;
            Class<?> param = loopAtVarargs ? params[varargsIndex].getComponentType() : params[i];
            args[i] = ObjectWrapper.unwrapIfNecessary(args[i]);
            if (loopAtVarargs && args.length == params.length && params[i].isInstance(args[i])) {
                Object varargsArray = args[i];
                int varargsLength = Array.getLength(varargsArray);
                args = Arrays.copyOf(args, args.length - 1 + varargsLength);
                System.arraycopy(varargsArray, 0, args, varargsIndex, varargsLength);
            }
            if (param.isPrimitive() && args[i] instanceof Number) {
                if (param == Byte.TYPE) {
                    args[i] = ((Number)args[i]).byteValue();
                } else if (param == Double.TYPE) {
                    args[i] = ((Number)args[i]).doubleValue();
                } else if (param == Float.TYPE) {
                    args[i] = Float.valueOf(((Number)args[i]).floatValue());
                } else if (param == Integer.TYPE) {
                    args[i] = ((Number)args[i]).intValue();
                } else if (param == Long.TYPE) {
                    args[i] = ((Number)args[i]).longValue();
                } else if (param == Short.TYPE) {
                    args[i] = ((Number)args[i]).shortValue();
                }
            }
            if (param.isArray() && JavaUtil.getArrayDepth(param) == JavaUtil.getArrayDepth(args[i].getClass()) && JavaUtil.isNumericClass(JavaUtil.getBaseComponent(param))) {
                args[i] = JavaUtil.convertNumericArray(args[i], JavaUtil.getBaseComponent(param));
            }
            if (args[i] instanceof String && (param == Character.TYPE || param == Character.class)) {
                args[i] = Character.valueOf(((String)args[i]).charAt(0));
            }
            if (param == Class.class) {
                if (args[i] instanceof JavaType) {
                    args[i] = ((JavaType)args[i]).getJavaClass();
                } else if (args[i] instanceof ClassInfo) {
                    args[i] = ((ClassInfo)args[i]).getC();
                }
            }
            if (!(args[i] instanceof Null)) continue;
            args[i] = null;
        }
        return args;
    }

    private void suggestParameters(Descriptor descriptor) {
        if (this.type != CallType.CONSTRUCTOR && this.type != CallType.METHOD) {
            return;
        }
        String guess = descriptor.getName();
        Class<?> javaClass = descriptor.getJavaClass();
        Stream<Executable> members = this.getExecutables(javaClass);
        List<String> matches = members.filter(e -> e.getName().equals(guess)).map(Executable::getParameters).map(params -> Arrays.stream(params).map(Parameter::getType).map(Class::getTypeName).collect(Collectors.joining(","))).collect(Collectors.toList());
        if (!matches.isEmpty()) {
            this.directError(String.format("Did you pass the wrong parameters? Here are the parameter signatures for %s:", guess));
            matches.forEach(parameterList -> this.directError(String.format("* %s(%s)", guess, parameterList)));
        }
    }

    private void suggestTypo(Descriptor descriptor) {
        String guess = descriptor.getName();
        Class<?> javaClass = descriptor.getJavaClass();
        Stream<Member> members = this.getMembers(javaClass);
        List<String> matches = members.map(Member::getName).filter(m -> !m.equals(guess)).distinct().map(m -> StringSimilarity.compare(guess, m, 3)).filter(Objects::nonNull).sorted().map(StringSimilarity.Result::getRight).collect(Collectors.toList());
        if (!matches.isEmpty()) {
            this.directError(String.format("Did you misspell the %s? You may have meant to type one of the following:", new Object[]{this.type}));
            matches.forEach(name -> this.directError("* " + name));
        }
    }

    private Stream<? extends Executable> getExecutables(Class<?> javaClass) {
        switch (this.type) {
            case METHOD: {
                return JavaUtil.methods(javaClass);
            }
            case CONSTRUCTOR: {
                return JavaUtil.constructors(javaClass);
            }
        }
        throw new IllegalStateException();
    }

    private Stream<? extends Member> getMembers(Class<?> javaClass) {
        switch (this.type) {
            case FIELD: {
                return JavaUtil.fields(javaClass);
            }
            case METHOD: {
                return JavaUtil.methods(javaClass);
            }
            case CONSTRUCTOR: {
                return JavaUtil.constructors(javaClass);
            }
        }
        throw new IllegalStateException();
    }

    private String argumentsMessage(Object ... arguments) {
        if (this.type == CallType.FIELD) {
            return "";
        }
        if (arguments.length == 0) {
            return " called without arguments";
        }
        return " called with (" + ExprJavaCall.argumentsToString(arguments) + ")";
    }

    private static String argumentsToString(Object ... arguments) {
        return Arrays.stream(arguments).map(arg -> String.format("%s (%s)", Classes.toString((Object)arg), SkriptMirrorUtil.getDebugName(SkriptMirrorUtil.getClass(arg)))).collect(Collectors.joining(", "));
    }

    static {
        Skript.registerExpression(ExprJavaCall.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[]{"[(2\u00a6try)] %object%..%string%(0\u00a6!|1\u00a6\\([%-objects%]\\))", "[(2\u00a6try)] %object%.<[^!(]*[^!(\\s]>(0\u00a6!|1\u00a6\\([%-objects%]\\))", "[(2\u00a6try)] [a] new %javatype%\\([%-objects%]\\)"});
    }

    private static enum CallType {
        FIELD,
        METHOD,
        CONSTRUCTOR;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

